/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.DCT;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaDCTExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaDCTExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.dense((double)0.0, (double[])new double[]{1.0, -2.0, 3.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)-1.0, (double[])new double[]{2.0, 4.0, -7.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)14.0, (double[])new double[]{-2.0, -5.0, 1.0})}));
        StructType schema = new StructType(new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        DCT dct = ((DCT)((DCT)new DCT().setInputCol("features")).setOutputCol("featuresDCT")).setInverse(false);
        Dataset dctDf = dct.transform(df);
        dctDf.select("featuresDCT", new String[0]).show(false);
        spark.stop();
    }
}

