/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator.framework.imps;

import java.util.ArrayList;
import java.util.Set;
import org.apache.hadoop.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.hadoop.shaded.org.apache.curator.framework.imps.NamespaceWatcher;
import org.apache.hadoop.shaded.org.apache.curator.framework.imps.RemoveWatchesBuilderImpl;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.shaded.org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatcherRemovalManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private final Set<NamespaceWatcher> entries = Sets.newConcurrentHashSet();

    WatcherRemovalManager(CuratorFrameworkImpl client) {
        this.client = client;
    }

    void add(NamespaceWatcher watcher) {
        watcher = Preconditions.checkNotNull(watcher, "watcher cannot be null");
        this.entries.add(watcher);
    }

    @VisibleForTesting
    Set<? extends Watcher> getEntries() {
        return Sets.newHashSet(this.entries);
    }

    void removeWatchers() {
        if (this.client.isZk34CompatibilityMode()) {
            return;
        }
        ArrayList<NamespaceWatcher> localEntries = Lists.newArrayList(this.entries);
        while (localEntries.size() > 0) {
            NamespaceWatcher watcher = (NamespaceWatcher)localEntries.remove(0);
            if (!this.entries.remove(watcher) || this.client.isZk34CompatibilityMode()) continue;
            try {
                this.log.debug("Removing watcher for path: " + watcher.getUnfixedPath());
                RemoveWatchesBuilderImpl builder = new RemoveWatchesBuilderImpl(this.client);
                builder.internalRemoval(watcher, watcher.getUnfixedPath());
            }
            catch (Exception e) {
                this.log.error("Could not remove watcher for path: " + watcher.getUnfixedPath());
            }
        }
    }

    void noteTriggeredWatcher(NamespaceWatcher watcher) {
        this.entries.remove(watcher);
    }
}

