/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriver;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalEventHandler;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.state.ConnectionState;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperLeaderRetrievalDriver
implements LeaderRetrievalDriver {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperLeaderRetrievalDriver.class);
    private final CuratorFramework client;
    private final TreeCache cache;
    private final String connectionInformationPath;
    private final ConnectionStateListener connectionStateListener = (client, newState) -> this.handleStateChange(newState);
    private final LeaderRetrievalEventHandler leaderRetrievalEventHandler;
    private final LeaderInformationClearancePolicy leaderInformationClearancePolicy;
    private final FatalErrorHandler fatalErrorHandler;
    private volatile boolean running;

    public ZooKeeperLeaderRetrievalDriver(CuratorFramework client2, String path, LeaderRetrievalEventHandler leaderRetrievalEventHandler, LeaderInformationClearancePolicy leaderInformationClearancePolicy, FatalErrorHandler fatalErrorHandler) throws Exception {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client2, (String)"CuratorFramework client");
        this.connectionInformationPath = ZooKeeperUtils.generateConnectionInformationPath(path);
        this.cache = ZooKeeperUtils.createTreeCache(client2, this.connectionInformationPath, this::retrieveLeaderInformationFromZooKeeper);
        this.leaderRetrievalEventHandler = (LeaderRetrievalEventHandler)Preconditions.checkNotNull((Object)leaderRetrievalEventHandler);
        this.leaderInformationClearancePolicy = leaderInformationClearancePolicy;
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        this.cache.start();
        client2.getConnectionStateListenable().addListener((Object)this.connectionStateListener);
        this.running = true;
    }

    @Override
    public void close() throws Exception {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOG.info("Closing {}.", (Object)this);
        this.client.getConnectionStateListenable().removeListener((Object)this.connectionStateListener);
        this.cache.close();
    }

    private void retrieveLeaderInformationFromZooKeeper() {
        try {
            byte[] data;
            LOG.debug("Leader node has changed.");
            ChildData childData = this.cache.getCurrentData(this.connectionInformationPath);
            if (childData != null && (data = childData.getData()) != null && data.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                ObjectInputStream ois = new ObjectInputStream(bais);
                String leaderAddress = ois.readUTF();
                UUID leaderSessionID = (UUID)ois.readObject();
                this.leaderRetrievalEventHandler.notifyLeaderAddress(LeaderInformation.known(leaderSessionID, leaderAddress));
                return;
            }
            this.notifyNoLeader();
        }
        catch (Exception e) {
            this.fatalErrorHandler.onFatalError((Throwable)((Object)new LeaderRetrievalException("Could not handle node changed event.", e)));
            ExceptionUtils.checkInterrupted((Throwable)e);
        }
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            case CONNECTED: {
                LOG.debug("Connected to ZooKeeper quorum. Leader retrieval can start.");
                break;
            }
            case SUSPENDED: {
                LOG.warn("Connection to ZooKeeper suspended, waiting for reconnection.");
                if (this.leaderInformationClearancePolicy != LeaderInformationClearancePolicy.ON_SUSPENDED_CONNECTION) break;
                this.notifyNoLeader();
                break;
            }
            case RECONNECTED: {
                LOG.info("Connection to ZooKeeper was reconnected. Leader retrieval can be restarted.");
                this.onReconnectedConnectionState();
                break;
            }
            case LOST: {
                LOG.warn("Connection to ZooKeeper lost. Can no longer retrieve the leader from ZooKeeper.");
                this.notifyNoLeader();
            }
        }
    }

    private void notifyNoLeader() {
        this.leaderRetrievalEventHandler.notifyLeaderAddress(LeaderInformation.empty());
    }

    private void onReconnectedConnectionState() {
        this.retrieveLeaderInformationFromZooKeeper();
    }

    public String toString() {
        return "ZookeeperLeaderRetrievalDriver{connectionInformationPath='" + this.connectionInformationPath + '\'' + '}';
    }

    @VisibleForTesting
    public String getConnectionInformationPath() {
        return this.connectionInformationPath;
    }

    public static enum LeaderInformationClearancePolicy {
        ON_SUSPENDED_CONNECTION,
        ON_LOST_CONNECTION;

    }
}

