/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.logic.Constraint;

public class AnyMatchPredicate<T>
implements Predicate<Iterable<T>> {
    @Nonnull
    private final Predicate<T> predicate;

    public AnyMatchPredicate(@Nonnull Predicate<T> target) {
        this.predicate = Constraint.isNotNull(target, "Target predicate cannot be null");
    }

    @Override
    public boolean test(@Nullable @NullableElements Iterable<T> inputs) {
        if (inputs == null) {
            return false;
        }
        for (T input : inputs) {
            if (!this.predicate.test(input)) continue;
            return true;
        }
        return false;
    }
}

