/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.LongLookup;

public class DoubleIntIndex
implements LongLookup {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private boolean sortOnValues = false;
    private final boolean fixedSize;
    private int[] keys;
    private int[] values;
    private int targetSearchValue;

    public DoubleIntIndex(int n) {
        this(n, false);
    }

    public DoubleIntIndex(int n, boolean bl) {
        this.capacity = n;
        this.keys = new int[n];
        this.values = new int[n];
        this.fixedSize = bl;
    }

    public int getKey(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[n];
    }

    @Override
    public long getLongKey(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return (long)this.keys[n] & 0xFFFFFFFFL;
    }

    @Override
    public long getLongValue(int n) {
        return this.values[n];
    }

    public int getValue(int n) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[n];
    }

    public void setKey(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.keys[n] = n2;
    }

    public void setValue(int n, int n2) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.values[n] = n2;
    }

    @Override
    public void setLongValue(int n, long l) {
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.values[n] = (int)l;
    }

    @Override
    public int size() {
        return this.count;
    }

    public int capacity() {
        return this.capacity;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] getValues() {
        return this.values;
    }

    @Override
    public long getTotalValues() {
        long l = 0L;
        for (int i = 0; i < this.count; ++i) {
            l += (long)this.values[i];
        }
        return l;
    }

    public void setSize(int n) {
        this.count = n;
    }

    @Override
    public boolean addUnsorted(long l, long l2) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.addUnsorted((int)l, (int)l2);
    }

    public boolean addUnsorted(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0) {
            if (this.sortOnValues) {
                if (n2 < this.values[this.count - 1]) {
                    this.sorted = false;
                }
            } else if (n < this.keys[this.count - 1]) {
                this.sorted = false;
            }
        }
        this.keys[this.count] = n;
        this.values[this.count] = n2;
        ++this.count;
        return true;
    }

    @Override
    public boolean addUnsorted(LongLookup longLookup) {
        if (!this.ensureCapacityToAdd(longLookup.size())) {
            return false;
        }
        this.sorted = false;
        for (int i = 0; i < longLookup.size(); ++i) {
            long l = longLookup.getLongKey(i);
            long l2 = longLookup.getLongValue(i);
            this.addUnsorted(l, l2);
        }
        return true;
    }

    private boolean ensureCapacityToAdd(int n) {
        if (this.count + n > this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            while (this.count + n > this.capacity) {
                this.doubleCapacity();
            }
        }
        return true;
    }

    public boolean addSorted(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0) {
            if (this.sortOnValues) {
                if (n2 < this.values[this.count - 1]) {
                    return false;
                }
                if (n2 == this.values[this.count - 1] && n < this.keys[this.count - 1]) {
                    return false;
                }
            } else if (n < this.keys[this.count - 1]) {
                return false;
            }
        }
        this.keys[this.count] = n;
        this.values[this.count] = n2;
        ++this.count;
        return true;
    }

    public boolean addUnique(int n, int n2) {
        if (this.sortOnValues) {
            throw new IllegalArgumentException();
        }
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n2 : n;
        int n3 = this.binaryEmptySlotSearch();
        if (n3 == -1) {
            return false;
        }
        if (this.count != n3) {
            this.moveRows(n3, n3 + 1, this.count - n3);
        }
        this.keys[n3] = n;
        this.values[n3] = n2;
        ++this.count;
        return true;
    }

    public boolean removeKey(int n) {
        if (this.sortOnValues) {
            throw new IllegalArgumentException();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        int n2 = this.binarySlotSearch(false);
        if (n2 == this.count) {
            return false;
        }
        if (this.keys[n2] != n) {
            return false;
        }
        this.remove(n2);
        return true;
    }

    public boolean addOrReplaceUnique(int n, int n2) {
        if (this.sortOnValues) {
            throw new IllegalArgumentException();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        int n3 = this.binarySlotSearch(false);
        if (n3 < this.count) {
            if (this.keys[n3] == n) {
                this.values[n3] = n2;
                return true;
            }
            if (this.count == this.capacity) {
                if (this.fixedSize) {
                    return false;
                }
                this.doubleCapacity();
            }
            this.moveRows(n3, n3 + 1, this.count - n3);
        } else if (this.count == this.capacity && this.fixedSize) {
            return false;
        }
        this.keys[n3] = n;
        this.values[n3] = n2;
        ++this.count;
        return true;
    }

    public int addCount(int n, int n2) {
        int n3;
        this.sortOnValues = false;
        if (this.addUnique(n, n2)) {
            return n2;
        }
        this.targetSearchValue = n;
        int n4 = n3 = this.binarySlotSearch(false);
        this.values[n4] = this.values[n4] + n2;
        return this.values[n3];
    }

    public int addCount(int n) {
        return this.addCount(n, 1);
    }

    @Override
    public int add(long l, long l2) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.add((int)l, (int)l2);
    }

    public int add(int n, int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return -1;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n2 : n;
        int n3 = this.binarySlotSearch(true);
        if (this.count != n3) {
            this.moveRows(n3, n3 + 1, this.count - n3);
        }
        this.keys[n3] = n;
        this.values[n3] = n2;
        ++this.count;
        return n3;
    }

    @Override
    public long lookup(long l) throws NoSuchElementException {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw new NoSuchElementException();
        }
        return this.lookup((int)l);
    }

    public int lookup(int n) throws NoSuchElementException {
        int n2;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n2 = this.findFirstEqualKeyIndex(n)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n2);
    }

    @Override
    public long lookup(long l, long l2) {
        int n;
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            return l2;
        }
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n = this.findFirstEqualKeyIndex((int)l)) == -1) {
            return l2;
        }
        return this.getValue(n);
    }

    public int lookup(int n, int n2) {
        int n3;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n3 = this.findFirstEqualKeyIndex(n)) == -1) {
            return n2;
        }
        return this.getValue(n3);
    }

    @Override
    public void clear() {
        this.removeAll();
    }

    @Override
    public LongLookup duplicate() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(this.capacity);
        this.copyTo(doubleIntIndex);
        return doubleIntIndex;
    }

    public int lookupFirstGreaterEqual(int n) throws NoSuchElementException {
        int n2;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n2 = this.findFirstGreaterEqualKeyIndex(n)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n2);
    }

    public void setValuesSearchTarget() {
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = true;
    }

    public void setKeysSearchTarget() {
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = false;
    }

    public int findFirstGreaterEqualKeyIndex(int n) {
        int n2 = this.findFirstGreaterEqualSlotIndex(n);
        return n2 == this.count ? -1 : n2;
    }

    public int findFirstEqualKeyIndex(int n) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        return this.binaryFirstSearch();
    }

    @Override
    public boolean compactLookupAsIntervals() {
        int n;
        if (this.size() == 0) {
            return false;
        }
        this.setKeysSearchTarget();
        if (!this.sorted) {
            this.fastQuickSort();
        }
        int n2 = 0;
        for (n = 1; n < this.count; ++n) {
            long l = this.keys[n2] + this.values[n2];
            if (l == (long)this.keys[n]) {
                int n3 = n2;
                this.values[n3] = this.values[n3] + this.values[n];
                continue;
            }
            this.keys[++n2] = this.keys[n];
            this.values[n2] = this.values[n];
        }
        for (n = n2 + 1; n < this.count; ++n) {
            this.keys[n] = 0;
            this.values[n] = 0;
        }
        if (this.count != n2 + 1) {
            this.setSize(n2 + 1);
            return true;
        }
        return false;
    }

    public int findFirstGreaterEqualSlotIndex(int n) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n;
        return this.binarySlotSearch(false);
    }

    private int binaryFirstSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.count;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
            n5 = n3;
        }
        return n5 == this.count ? -1 : n5;
    }

    private int binarySlotSearch(boolean bl) {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 <= 0) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        return n;
    }

    private int binaryEmptySlotSearch() {
        int n = 0;
        int n2 = this.count;
        int n3 = 0;
        int n4 = 0;
        while (n < n2) {
            n3 = n + n2 >>> 1;
            n4 = this.compare(n3);
            if (n4 < 0) {
                n2 = n3;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return -1;
        }
        return n;
    }

    public void sortOnKeys() {
        this.sortOnValues = false;
        this.fastQuickSort();
    }

    public void sortOnValues() {
        this.sortOnValues = true;
        this.fastQuickSort();
    }

    @Override
    public void sort() {
        if (this.sortOnValues || this.count <= 16384) {
            this.fastQuickSortRecursive();
        } else {
            this.fastQuickSort();
        }
    }

    private void fastQuickSort() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(32768);
        int n = 16;
        doubleIntIndex.push(0, this.count - 1);
        while (doubleIntIndex.size() > 0) {
            int n2 = doubleIntIndex.peekKey();
            int n3 = doubleIntIndex.peekValue();
            doubleIntIndex.pop();
            if (n3 - n2 < n) continue;
            int n4 = this.partition(n2, n3);
            doubleIntIndex.push(n2, n4 - 1);
            doubleIntIndex.push(n4 + 1, n3);
        }
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private int partition(int n, int n2) {
        int n3 = n + n2 >>> 1;
        if (this.keys[n3] < this.keys[n + n3 >>> 1]) {
            this.swap(n3, n + n3 >>> 1);
        }
        if (this.keys[n2 + n3 >>> 1] < this.keys[n + n3 >>> 1]) {
            this.swap(n2 + n3 >>> 1, n + n3 >>> 1);
        }
        if (this.keys[n2 + n3 >>> 1] < this.keys[n3]) {
            this.swap(n2 + n3 >>> 1, n3);
        }
        int n4 = this.keys[n3];
        int n5 = n - 1;
        int n6 = n2;
        this.swap(n3, n2);
        while (true) {
            if (this.keys[++n5] < n4) {
                continue;
            }
            while (n4 < this.keys[--n6]) {
            }
            if (n6 < n5) break;
            this.swap(n5, n6);
        }
        this.swap(n5, n2);
        return n5;
    }

    private void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int n, int n2) {
        int n3 = 16;
        if (n2 - n > n3) {
            int n4 = n2 + n >>> 1;
            if (this.lessThan(n4, n)) {
                this.swap(n, n4);
            }
            if (this.lessThan(n2, n)) {
                this.swap(n, n2);
            }
            if (this.lessThan(n2, n4)) {
                this.swap(n4, n2);
            }
            int n5 = n2 - 1;
            this.swap(n4, n5);
            n4 = n;
            int n6 = n5;
            while (true) {
                if (this.lessThan(++n4, n6)) {
                    continue;
                }
                while (this.lessThan(n6, --n5)) {
                }
                if (n5 < n4) break;
                this.swap(n4, n5);
            }
            this.swap(n4, n2 - 1);
            this.quickSort(n, n5);
            this.quickSort(n4 + 1, n2);
        }
    }

    private void insertionSort(int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3;
            for (n3 = i; n3 > n && this.lessThan(i, n3 - 1); --n3) {
            }
            if (i == n3) continue;
            this.moveAndInsertRow(i, n3);
        }
    }

    protected void moveAndInsertRow(int n, int n2) {
        int n3 = this.keys[n];
        int n4 = this.values[n];
        this.moveRows(n2, n2 + 1, n - n2);
        this.keys[n2] = n3;
        this.values[n2] = n4;
    }

    protected void swap(int n, int n2) {
        int n3 = this.keys[n];
        int n4 = this.values[n];
        this.keys[n] = this.keys[n2];
        this.values[n] = this.values[n2];
        this.keys[n2] = n3;
        this.values[n2] = n4;
    }

    protected int compare(int n) {
        if (this.sortOnValues) {
            if (this.targetSearchValue > this.values[n]) {
                return 1;
            }
            if (this.targetSearchValue < this.values[n]) {
                return -1;
            }
            return 0;
        }
        if (this.targetSearchValue > this.keys[n]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[n]) {
            return -1;
        }
        return 0;
    }

    protected boolean lessThan(int n, int n2) {
        if (this.sortOnValues) {
            if (this.values[n] < this.values[n2]) {
                return true;
            }
            if (this.values[n] > this.values[n2]) {
                return false;
            }
        }
        return this.keys[n] < this.keys[n2];
    }

    protected void moveRows(int n, int n2, int n3) {
        System.arraycopy(this.keys, n, this.keys, n2, n3);
        System.arraycopy(this.values, n, this.values, n2, n3);
    }

    protected void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (int[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    public void removeRange(int n, int n2) {
        ArrayUtil.adjustArray(73, this.keys, this.count, n, n - n2);
        ArrayUtil.adjustArray(73, this.values, this.count, n, n - n2);
        this.count -= n2 - n;
    }

    public void removeAll() {
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, 0);
        this.count = 0;
        this.sorted = true;
    }

    public void copyTo(DoubleIntIndex doubleIntIndex) {
        System.arraycopy(this.keys, 0, doubleIntIndex.keys, 0, this.count);
        System.arraycopy(this.values, 0, doubleIntIndex.values, 0, this.count);
        doubleIntIndex.setSize(this.count);
        doubleIntIndex.sorted = false;
    }

    public final void remove(int n) {
        this.moveRows(n + 1, n, this.count - n - 1);
        --this.count;
        this.keys[this.count] = 0;
        this.values[this.count] = 0;
    }

    int peekKey() {
        return this.getKey(this.count - 1);
    }

    int peekValue() {
        return this.getValue(this.count - 1);
    }

    boolean pop() {
        if (this.count > 0) {
            --this.count;
            return true;
        }
        return false;
    }

    boolean push(int n, int n2) {
        return this.addUnsorted(n, n2);
    }
}

