/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MutableDoublePointData
implements DoublePointData {
    private long startEpochNanos;
    private long epochNanos;
    private Attributes attributes = Attributes.empty();
    private double value;
    private List<DoubleExemplarData> exemplars = Collections.emptyList();

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public void set(DoublePointData point) {
        this.set(point.getStartEpochNanos(), point.getEpochNanos(), point.getAttributes(), point.getValue(), point.getExemplars());
    }

    public void set(long startEpochNanos, long epochNanos, Attributes attributes, double value) {
        this.set(startEpochNanos, epochNanos, attributes, value, Collections.emptyList());
    }

    public void set(long startEpochNanos, long epochNanos, Attributes attributes, double value, List<DoubleExemplarData> exemplars) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        this.attributes = attributes;
        this.value = value;
        this.exemplars = exemplars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MutableDoublePointData)) {
            return false;
        }
        MutableDoublePointData pointData = (MutableDoublePointData)o;
        return this.startEpochNanos == pointData.startEpochNanos && this.epochNanos == pointData.epochNanos && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(pointData.value) && Objects.equals(this.attributes, pointData.attributes) && Objects.equals(this.exemplars, pointData.exemplars);
    }

    public int hashCode() {
        int hashcode = 1;
        hashcode *= 1000003;
        hashcode ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        hashcode *= 1000003;
        hashcode ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        hashcode *= 1000003;
        hashcode ^= this.attributes.hashCode();
        hashcode *= 1000003;
        hashcode ^= (int)(Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value));
        hashcode *= 1000003;
        return hashcode ^= this.exemplars.hashCode();
    }

    public String toString() {
        return "MutableDoublePointData{startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", attributes=" + this.attributes + ", value=" + this.value + ", exemplars=" + this.exemplars + '}';
    }
}

