/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import jakarta.enterprise.concurrent.ContextService;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.BaseConvertDefinitions;
import org.apache.openejb.config.CompManagedBean;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.PropertyPlaceHolderHelper;

public class ConvertContextServiceDefinitions
extends BaseConvertDefinitions {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        List<JndiConsumer> jndiConsumers = this.collectConsumers(appModule);
        KeyedCollection contextServices = new KeyedCollection();
        KeyedCollection contextServicesFromCompManagedBeans = new KeyedCollection();
        for (JndiConsumer consumer : jndiConsumers) {
            if (consumer == null) continue;
            if (consumer instanceof CompManagedBean) {
                contextServicesFromCompManagedBeans.addAll(consumer.getContextServiceMap().values());
                continue;
            }
            contextServices.addAll(consumer.getContextServiceMap().values());
        }
        Map dataSourcesMap = contextServices.toMap();
        for (org.apache.openejb.jee.ContextService contextService : contextServicesFromCompManagedBeans) {
            if (dataSourcesMap.containsKey(contextService.getName().getvalue())) continue;
            contextServices.add((Object)contextService);
        }
        for (org.apache.openejb.jee.ContextService dataSource : contextServices) {
            appModule.getResources().add(this.toResource(dataSource));
        }
        return appModule;
    }

    private Resource toResource(org.apache.openejb.jee.ContextService contextService) {
        String name = this.cleanUpName(contextService.getName().getvalue());
        Resource def = new Resource(name, ContextService.class.getName());
        def.setJndi(contextService.getName().getvalue().replaceFirst("java:", ""));
        def.setType(ContextService.class.getName());
        Properties p = def.getProperties();
        ConvertContextServiceDefinitions.put(p, "propagated", Join.join(",", contextService.getPropagated()));
        ConvertContextServiceDefinitions.put(p, "cleared", Join.join(",", contextService.getCleared()));
        ConvertContextServiceDefinitions.put(p, "unchanged", Join.join(",", contextService.getUnchanged()));
        ConvertContextServiceDefinitions.put(p, "JndiName", def.getJndi());
        return def;
    }

    private static void put(Properties properties, String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        properties.put(key, PropertyPlaceHolderHelper.value(String.valueOf(value)));
    }
}

