/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore.jcache;

import java.net.URL;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreException;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;
import org.apache.cxf.ws.security.tokenstore.jcache.JCacheTokenStore;
import org.apache.wss4j.common.util.Loader;

public class JCacheTokenStoreFactory
extends TokenStoreFactory {
    private static final String DEFAULT_CONFIG_FILE = "cxf-jcache.xml";

    @Override
    public TokenStore newTokenStore(String key, Message message) throws TokenStoreException {
        URL configFileURL = SecurityUtils.getConfigFileURL((Message)message, (String)"ws-security.cache.config.file", (String)DEFAULT_CONFIG_FILE);
        if (configFileURL == null) {
            configFileURL = Loader.getResource((ClassLoader)this.getClass().getClassLoader(), (String)DEFAULT_CONFIG_FILE);
        }
        return new JCacheTokenStore(key, message.getExchange().getBus(), configFileURL);
    }
}

