/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.AsyncExecutorProvider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.AbstractQueue;
import java.util.OptionalInt;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class DefaultAsyncExecutorProvider
implements AsyncExecutorProvider {
    private final ExecutorService executor;

    @Inject
    public DefaultAsyncExecutorProvider(@ConfigProperty(name="io.smallrye.faulttolerance.mainThreadPoolSize") OptionalInt mainThreadPoolSize, @ConfigProperty(name="io.smallrye.faulttolerance.mainThreadPoolQueueSize") OptionalInt mainThreadPoolQueueSize, @ConfigProperty(name="io.smallrye.faulttolerance.globalThreadPoolSize") OptionalInt globalThreadPoolSize) {
        int maxSize = mainThreadPoolSize.orElse(globalThreadPoolSize.orElse(100));
        int queueSize = mainThreadPoolQueueSize.orElse(-1);
        if (maxSize < 5) {
            throw new IllegalArgumentException("The main thread pool size must be >= 5.");
        }
        if (queueSize < -1) {
            throw new IllegalArgumentException("The main thread pool queue size must be -1, 0, or > 1");
        }
        AbstractQueue queue = queueSize > 1 ? new LinkedBlockingQueue(queueSize) : (queueSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue());
        ThreadPoolExecutor executor = new ThreadPoolExecutor(maxSize, maxSize, 1L, TimeUnit.MINUTES, (BlockingQueue<Runnable>)((Object)queue), this.threadFactory());
        executor.allowCoreThreadTimeOut(true);
        this.executor = executor;
    }

    @Override
    public ExecutorService get() {
        return this.executor;
    }

    protected ThreadFactory threadFactory() {
        return Executors.defaultThreadFactory();
    }
}

