/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.store.imap.connection;

import jakarta.mail.MessagingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.mail.store.imap.connection.IMAPResponseTokenizer;
import org.apache.geronimo.mail.util.ResponseFormatException;

public class IMAPBodySection {
    public static final int BODY = 0;
    public static final int HEADERS = 1;
    public static final int HEADERSUBSET = 2;
    public static final int MIME = 3;
    public static final int TEXT = 4;
    public String partNumber = "1";
    public String sectionName = "";
    public int section;
    public int start = -1;
    public int length = -1;
    public List headers = null;

    public IMAPBodySection(int section) {
        this.section = section;
        this.partNumber = "1";
        this.start = -1;
        this.length = -1;
    }

    public IMAPBodySection(IMAPResponseTokenizer source) throws MessagingException {
        if (!source.peek(false, true).isType(91)) {
            this.section = 0;
            return;
        }
        IMAPResponseTokenizer.Token token = source.next(false, true);
        token = source.next(false, true);
        if (token.isType(-4)) {
            token = this.parsePartNumber(token, source);
        }
        if (token.isType(-1)) {
            token = this.parseSectionName(token, source);
        }
        if (token.isType(40)) {
            token = this.parseHeaderList(source);
        }
        if (!token.isType(93)) {
            throw new ResponseFormatException("Invalid section identifier on FETCH response");
        }
        this.parseSubstringValues(source);
        if (this.sectionName.equals("")) {
            this.section = 0;
        } else if (this.sectionName.equals("HEADER")) {
            this.section = 1;
        } else if (this.sectionName.equals("HEADER.FIELDS")) {
            this.section = 2;
        } else if (this.sectionName.equals("HEADER.FIELDS.NOT")) {
            this.section = 2;
        } else if (this.sectionName.equals("TEXT")) {
            this.section = 4;
        } else if (this.sectionName.equals("MIME")) {
            this.section = 3;
        }
    }

    private IMAPResponseTokenizer.Token parsePartNumber(IMAPResponseTokenizer.Token token, IMAPResponseTokenizer source) throws MessagingException {
        StringBuffer part = new StringBuffer(token.getValue());
        token = source.next(false, true);
        while (true) {
            if (!token.isType(46)) {
                this.partNumber = part.toString();
                return token;
            }
            token = source.next(false, true);
            if (!token.isType(-4)) break;
            part.append('.');
            part.append(token.getValue());
            token = source.next(false, true);
        }
        this.partNumber = part.toString();
        return token;
    }

    private IMAPResponseTokenizer.Token parseSectionName(IMAPResponseTokenizer.Token token, IMAPResponseTokenizer source) throws MessagingException {
        StringBuffer part = new StringBuffer(token.getValue());
        token = source.next(false, true);
        while (true) {
            if (!token.isType(46)) {
                this.sectionName = part.toString();
                return token;
            }
            part.append('.');
            part.append(source.readString());
            token = source.next(false, true);
        }
    }

    private IMAPResponseTokenizer.Token parseHeaderList(IMAPResponseTokenizer source) throws MessagingException {
        this.headers = new ArrayList();
        while (source.notListEnd()) {
            String value = source.readString();
            this.headers.add(value);
        }
        source.next();
        return source.next(false, true);
    }

    private void parseSubstringValues(IMAPResponseTokenizer source) throws MessagingException {
        if (!source.peek(false, true).isType(60)) {
            return;
        }
        source.next(false, true);
        this.start = source.next(false, true).getInteger();
        source.next(false, true);
        this.length = source.next(false, true).getInteger();
        source.next(false, true);
    }
}

