/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.faces.FacesWrapper;
import jakarta.faces.view.Location;
import jakarta.faces.view.facelets.TagAttribute;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.myfaces.view.facelets.el.ContextAware;
import org.apache.myfaces.view.facelets.el.ContextAwareELException;
import org.apache.myfaces.view.facelets.el.ContextAwareMethodNotFoundException;
import org.apache.myfaces.view.facelets.el.ContextAwarePropertyNotFoundException;

public final class ContextAwareTagMethodExpression
extends MethodExpression
implements Externalizable,
FacesWrapper<MethodExpression>,
ContextAware {
    private static final long serialVersionUID = 1L;
    private MethodExpression _wrapped;
    private Location _location;
    private String _qName;

    public ContextAwareTagMethodExpression() {
    }

    public ContextAwareTagMethodExpression(TagAttribute tagAttribute, MethodExpression methodExpression) {
        this._location = tagAttribute.getLocation();
        this._qName = tagAttribute.getQName();
        this._wrapped = methodExpression;
    }

    public MethodInfo getMethodInfo(ELContext context) {
        try {
            return this._wrapped.getMethodInfo(context);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ContextAwarePropertyNotFoundException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new ContextAwareMethodNotFoundException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), mnfe);
        }
        catch (ELException e) {
            throw new ContextAwareELException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), e);
        }
    }

    public Object invoke(ELContext context, Object[] params) {
        try {
            return this._wrapped.invoke(context, params);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ContextAwarePropertyNotFoundException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new ContextAwareMethodNotFoundException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), mnfe);
        }
        catch (ELException e) {
            throw new ContextAwareELException(this.getLocation(), this.getLocalExpressionString(), this.getQName(), e);
        }
    }

    private String getLocalExpressionString() {
        String expressionString = null;
        try {
            expressionString = this.getExpressionString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return expressionString;
    }

    @Override
    public String getExpressionString() {
        return this._wrapped.getExpressionString();
    }

    public boolean equals(Object obj) {
        return this._wrapped.equals(obj);
    }

    public int hashCode() {
        return this._wrapped.hashCode();
    }

    public boolean isLiteralText() {
        return this._wrapped.isLiteralText();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._wrapped);
        out.writeObject(this._location);
        out.writeUTF(this._qName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._wrapped = (MethodExpression)in.readObject();
        this._location = (Location)in.readObject();
        this._qName = in.readUTF();
    }

    public String toString() {
        return this._location + ": " + this._wrapped;
    }

    @Override
    public Location getLocation() {
        return this._location;
    }

    @Override
    public String getQName() {
        return this._qName;
    }

    public MethodExpression getWrapped() {
        return this._wrapped;
    }
}

