/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import java.util.Objects;
import org.apache.myfaces.resource.ResourceMeta;

public class ResourceMetaImpl
extends ResourceMeta {
    private final String _prefix;
    private final String _libraryName;
    private final String _libraryVersion;
    private final String _resourceName;
    private final String _resourceVersion;
    private final String _contractName;
    private Long lastModified;
    private String resourceIdentifier = null;

    public ResourceMetaImpl(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        this(prefix, libraryName, libraryVersion, resourceName, resourceVersion, null);
    }

    public ResourceMetaImpl(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion, String contractName) {
        this._prefix = prefix;
        this._libraryName = libraryName;
        this._libraryVersion = libraryVersion;
        this._resourceName = resourceName;
        this._resourceVersion = resourceVersion;
        this._contractName = contractName;
    }

    @Override
    public String getLibraryName() {
        return this._libraryName;
    }

    @Override
    public String getResourceName() {
        return this._resourceName;
    }

    @Override
    public String getLocalePrefix() {
        return this._prefix;
    }

    @Override
    public String getLibraryVersion() {
        return this._libraryVersion;
    }

    @Override
    public String getResourceVersion() {
        return this._resourceVersion;
    }

    @Override
    public String getContractName() {
        return this._contractName;
    }

    @Override
    public String getResourceIdentifier() {
        if (this.resourceIdentifier == null) {
            StringBuilder builder = new StringBuilder();
            boolean firstSlashAdded = false;
            if (this._prefix != null && this._prefix.length() > 0) {
                builder.append(this._prefix);
                firstSlashAdded = true;
            }
            if (this._libraryName != null) {
                if (firstSlashAdded) {
                    builder.append('/');
                }
                builder.append(this._libraryName);
                firstSlashAdded = true;
            }
            if (this._libraryVersion != null) {
                if (firstSlashAdded) {
                    builder.append('/');
                }
                builder.append(this._libraryVersion);
                firstSlashAdded = true;
            }
            if (this._resourceName != null) {
                if (firstSlashAdded) {
                    builder.append('/');
                }
                builder.append(this._resourceName);
                firstSlashAdded = true;
            }
            if (this._resourceVersion != null) {
                if (firstSlashAdded) {
                    builder.append('/');
                }
                builder.append(this._resourceVersion);
                builder.append(this._resourceName.substring(this._resourceName.lastIndexOf(46)));
                firstSlashAdded = true;
            }
            this.resourceIdentifier = builder.toString();
        }
        return this.resourceIdentifier;
    }

    @Override
    public boolean couldResourceContainValueExpressions() {
        return false;
    }

    @Override
    public Long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this._libraryName);
        hash = 79 * hash + Objects.hashCode(this._libraryVersion);
        hash = 79 * hash + Objects.hashCode(this._resourceName);
        hash = 79 * hash + Objects.hashCode(this._resourceVersion);
        hash = 79 * hash + Objects.hashCode(this._contractName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceMetaImpl other = (ResourceMetaImpl)obj;
        if (!Objects.equals(this._prefix, other._prefix)) {
            return false;
        }
        if (!Objects.equals(this._libraryName, other._libraryName)) {
            return false;
        }
        if (!Objects.equals(this._libraryVersion, other._libraryVersion)) {
            return false;
        }
        if (!Objects.equals(this._resourceName, other._resourceName)) {
            return false;
        }
        if (!Objects.equals(this._resourceVersion, other._resourceVersion)) {
            return false;
        }
        return Objects.equals(this._contractName, other._contractName);
    }
}

