/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.proxy;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.IntFunction;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DetachedStateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.CollectionChangeTracker;
import org.apache.openjpa.util.DelayedCollectionChangeTrackerImpl;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.Proxy;
import org.apache.openjpa.util.proxy.DelayedProxy;
import org.apache.openjpa.util.proxy.ProxyCollection;
import org.apache.openjpa.util.proxy.ProxyCollections;

public class DelayedLinkedListProxy
extends LinkedList
implements ProxyCollection,
DelayedProxy {
    private transient OpenJPAStateManager sm;
    private transient int field;
    private transient CollectionChangeTracker changeTracker;
    private transient Class elementType;
    private transient OpenJPAStateManager _ownerSm;
    private transient boolean _directAccess = false;
    private transient BrokerFactory _brokerFactory = null;
    private transient Broker _broker = null;
    private transient OpenJPAStateManager _delayedSm;
    private transient int _delayedField;
    private transient boolean _detached = false;

    public DelayedLinkedListProxy(Collection paramCollection) {
        super(paramCollection);
    }

    public DelayedLinkedListProxy() {
    }

    @Override
    public void setOwner(OpenJPAStateManager paramOpenJPAStateManager, int paramInt) {
        if (this.sm != null && this.detaching(paramOpenJPAStateManager, paramInt)) {
            this._detached = true;
            this._delayedSm = this.sm;
            this._delayedField = this.field;
        } else {
            this._detached = false;
        }
        this.sm = paramOpenJPAStateManager;
        if (this.sm != null && this.sm.getPersistenceCapable() != null) {
            this._ownerSm = (OpenJPAStateManager)this.sm.getPersistenceCapable().pcGetStateManager();
        }
        this.field = paramInt;
        if (this.sm != null && this.sm.getContext() != null) {
            this._brokerFactory = this.sm.getContext().getBroker().getBrokerFactory();
        }
    }

    private boolean detaching(OpenJPAStateManager paramOpenJPAStateManager, int paramInt) {
        return paramOpenJPAStateManager == null && paramInt == -1 || paramOpenJPAStateManager != null && paramOpenJPAStateManager instanceof DetachedStateManager;
    }

    @Override
    public OpenJPAStateManager getOwner() {
        return this.sm;
    }

    @Override
    public int getOwnerField() {
        return this.field;
    }

    @Override
    public ChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    protected void setChangeTracker(CollectionChangeTracker ct) {
        this.changeTracker = ct;
    }

    @Override
    public Object copy(Object paramObject) {
        return new LinkedList((Collection)paramObject);
    }

    @Override
    public Class getElementType() {
        return this.elementType;
    }

    protected void setElementType(Class<?> elemType) {
        this.elementType = elemType;
    }

    @Override
    public ProxyCollection newInstance(Class paramClass, Comparator paramComparator, boolean paramBoolean1, boolean paramBoolean2) {
        DelayedLinkedListProxy localproxy = new DelayedLinkedListProxy();
        localproxy.elementType = paramClass;
        if (paramBoolean1) {
            localproxy.changeTracker = new DelayedCollectionChangeTrackerImpl(localproxy, true, true, paramBoolean2);
        }
        return localproxy;
    }

    @Override
    public int getDelayedField() {
        if (this.field == -1 || this._detached) {
            return this._delayedField;
        }
        return this.field;
    }

    @Override
    public OpenJPAStateManager getDelayedOwner() {
        if (this.sm == null || this._detached) {
            return this._delayedSm;
        }
        return this.sm;
    }

    @Override
    public boolean isDirectAccess() {
        return this._directAccess;
    }

    @Override
    public void setDirectAccess(boolean direct) {
        this._directAccess = direct;
    }

    public BrokerFactory getBrokerFactory() {
        return this._brokerFactory;
    }

    @Override
    public void load() {
        ProxyCollections.loadCollection(this);
    }

    @Override
    public Broker getBroker() {
        if ((this._broker == null || this._broker.isClosed()) && this._brokerFactory != null) {
            this._broker = this._brokerFactory.newBroker();
        }
        return this._broker;
    }

    @Override
    public void closeBroker() {
        if (this._broker != null && !this._broker.isClosed()) {
            this._broker.setAutoDetach(2);
            this._broker.close();
            this._broker = null;
        }
    }

    @Override
    public OpenJPAStateManager getOwnerStateManager() {
        return this._ownerSm;
    }

    @Override
    public boolean isDetached() {
        return this._detached;
    }

    public boolean isDelayLoad() {
        return ProxyCollections.isDelayed(this);
    }

    @Override
    public Object clone() {
        if (this._directAccess) {
            return super.clone();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Proxy localProxy = (Proxy)super.clone();
        localProxy.setOwner(null, 0);
        return localProxy;
    }

    @Override
    public void add(int paramInt, Object paramObject) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeAdd(this, paramInt, paramObject);
        super.add(paramInt, paramObject);
    }

    @Override
    public boolean add(Object paramObject) {
        if (this._directAccess) {
            return super.add(paramObject);
        }
        ProxyCollections.beforeAdd(this, paramObject);
        boolean bool = super.add(paramObject);
        return ProxyCollections.afterAdd(this, paramObject, bool);
    }

    @Override
    public void clear() {
        if (!this._directAccess) {
            if (this.isDelayLoad()) {
                this.load();
            }
            ProxyCollections.beforeClear(this);
        }
        super.clear();
    }

    @Override
    public boolean addAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.addAll(paramCollection);
        }
        return ProxyCollections.addAll(this, paramCollection);
    }

    @Override
    public boolean addAll(int paramInt, Collection paramCollection) {
        if (this._directAccess) {
            return super.addAll(paramInt, paramCollection);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        return ProxyCollections.addAll(this, paramInt, paramCollection);
    }

    @Override
    public boolean remove(Object paramObject) {
        if (this._directAccess) {
            return super.remove(paramObject);
        }
        ProxyCollections.beforeRemove((ProxyCollection)this, paramObject);
        this.setDirectAccess(true);
        boolean bool = super.remove(paramObject);
        this.setDirectAccess(false);
        return ProxyCollections.afterRemove((ProxyCollection)this, paramObject, bool);
    }

    @Override
    public Object remove(int paramInt) {
        if (this._directAccess) {
            return super.remove(paramInt);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeRemove((ProxyCollection)this, paramInt);
        Object localObject = super.remove(paramInt);
        return ProxyCollections.afterRemove((ProxyCollection)this, paramInt, localObject);
    }

    @Override
    public Object remove() {
        if (this._directAccess) {
            return super.remove();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeRemove(this);
        Object localObject = super.remove();
        return ProxyCollections.afterRemove(this, localObject);
    }

    @Override
    public Object set(int paramInt, Object paramObject) {
        if (this._directAccess) {
            return super.set(paramInt, paramObject);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeSet(this, paramInt, paramObject);
        Object localObject = super.set(paramInt, paramObject);
        return ProxyCollections.afterSet(this, paramInt, paramObject, localObject);
    }

    @Override
    public Object poll() {
        if (this._directAccess) {
            return super.poll();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforePoll(this);
        Object localObject = super.poll();
        return ProxyCollections.afterPoll(this, localObject);
    }

    @Override
    public ListIterator listIterator(int paramInt) {
        if (this._directAccess) {
            return super.listIterator(paramInt);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ListIterator localListIterator = super.listIterator(paramInt);
        return ProxyCollections.afterListIterator(this, paramInt, localListIterator);
    }

    @Override
    public void addFirst(Object paramObject) {
        if (this._directAccess) {
            super.addFirst(paramObject);
            return;
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeAddFirst(this, paramObject);
        super.addFirst(paramObject);
    }

    @Override
    public void addLast(Object paramObject) {
        if (this._directAccess) {
            super.addLast(paramObject);
            return;
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeAddLast(this, paramObject);
        super.addLast(paramObject);
        ProxyCollections.afterAddLast(this, paramObject);
    }

    @Override
    public boolean offer(Object paramObject) {
        if (this._directAccess) {
            return super.offer(paramObject);
        }
        ProxyCollections.beforeOffer(this, paramObject);
        boolean bool = super.offer(paramObject);
        return ProxyCollections.afterOffer(this, paramObject, bool);
    }

    @Override
    public Object removeFirst() {
        if (this._directAccess) {
            return super.removeFirst();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeRemoveFirst(this);
        Object localObject = super.removeFirst();
        return ProxyCollections.afterRemoveFirst(this, localObject);
    }

    @Override
    public Object removeLast() {
        if (this._directAccess) {
            return super.removeLast();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeRemoveLast(this);
        Object localObject = super.removeLast();
        return ProxyCollections.afterRemoveLast(this, localObject);
    }

    @Override
    public Iterator iterator() {
        if (this._directAccess) {
            return super.iterator();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Iterator localIterator = super.iterator();
        return ProxyCollections.afterIterator(this, localIterator);
    }

    @Override
    public ListIterator listIterator() {
        if (this._directAccess) {
            return super.listIterator();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ListIterator localListIterator = super.listIterator();
        return ProxyCollections.afterListIterator(this, localListIterator);
    }

    @Override
    public boolean removeAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.removeAll(paramCollection);
        }
        return ProxyCollections.removeAll(this, paramCollection);
    }

    @Override
    public boolean retainAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.retainAll(paramCollection);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        return ProxyCollections.retainAll(this, paramCollection);
    }

    @Override
    public boolean removeFirstOccurrence(Object paramObject) {
        if (this._directAccess) {
            return super.removeFirstOccurrence(paramObject);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Proxies.dirty(this, true);
        return super.removeFirstOccurrence(paramObject);
    }

    @Override
    public boolean removeLastOccurrence(Object paramObject) {
        if (this._directAccess) {
            return super.removeLastOccurrence(paramObject);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Proxies.dirty(this, true);
        return super.removeLastOccurrence(paramObject);
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.isDelayLoad()) {
            this.load();
        }
        return Proxies.writeReplace(this, true);
    }

    @Override
    public boolean equals(Object paramObject) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.equals(paramObject);
    }

    @Override
    public int hashCode() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.hashCode();
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.lastIndexOf(o);
    }

    @Override
    public int indexOf(Object o) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.indexOf(o);
    }

    @Override
    public Object get(int index) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.get(index);
    }

    @Override
    public boolean containsAll(Collection c) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.containsAll(c);
    }

    @Override
    public Object[] toArray() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray();
    }

    @Override
    public Object[] toArray(Object[] array) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray(array);
    }

    public Object[] toArray(IntFunction generator) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray(generator);
    }

    @Override
    public boolean contains(Object object) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.contains(object);
    }

    @Override
    public boolean isEmpty() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.isEmpty();
    }

    @Override
    public int size() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.size();
    }

    @Override
    public boolean offerFirst(Object paramObject) {
        if (this._directAccess) {
            return super.offerFirst(paramObject);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        return super.offerFirst(paramObject);
    }

    @Override
    public boolean offerLast(Object paramObject) {
        if (this._directAccess) {
            return super.offerLast(paramObject);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        return super.offerLast(paramObject);
    }

    @Override
    public Object pollFirst() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.pollFirst();
    }

    @Override
    public Object pollLast() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.pollLast();
    }

    @Override
    public Object getFirst() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.getFirst();
    }

    @Override
    public Object getLast() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.getLast();
    }

    @Override
    public Object peekFirst() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.peekFirst();
    }

    @Override
    public Object peekLast() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.peekLast();
    }

    @Override
    public Object element() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.element();
    }

    @Override
    public Object peek() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.peek();
    }

    @Override
    public void push(Object o) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        super.push(o);
    }

    @Override
    public Object pop() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.pop();
    }

    @Override
    public Iterator descendingIterator() {
        if (this._directAccess) {
            return super.descendingIterator();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Iterator localIterator = super.descendingIterator();
        return ProxyCollections.afterIterator(this, localIterator);
    }
}

