/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.client;

import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.netty.IOMode;

public class TransportConf {
    private final RssConf rssConf;

    public TransportConf(RssConf rssConf) {
        this.rssConf = rssConf;
    }

    public IOMode ioMode() {
        return this.rssConf.get(RssClientConf.NETTY_IO_MODE);
    }

    public int connectTimeoutMs() {
        return this.rssConf.get(RssClientConf.NETTY_IO_CONNECT_TIMEOUT_MS);
    }

    public int connectionTimeoutMs() {
        return this.rssConf.get(RssClientConf.NETTY_IO_CONNECTION_TIMEOUT_MS);
    }

    public int clientThreads() {
        return this.rssConf.get(RssClientConf.NETTY_CLIENT_THREADS);
    }

    public double clientThreadsRatio() {
        return this.rssConf.get(RssClientConf.NETTY_CLIENT_THREADS_RATIO);
    }

    public int numConnectionsPerPeer() {
        return this.rssConf.get(RssClientConf.NETTY_CLIENT_NUM_CONNECTIONS_PER_PEER);
    }

    public boolean preferDirectBufs() {
        return this.rssConf.get(RssClientConf.NETTY_CLIENT_PREFER_DIRECT_BUFS);
    }

    public boolean isPooledAllocatorEnabled() {
        return this.rssConf.get(RssClientConf.NETTY_CLIENT_POOLED_ALLOCATOR_ENABLED);
    }

    public boolean isSharedAllocatorEnabled() {
        return this.rssConf.get(RssClientConf.NETTY_CLIENT_SHARED_ALLOCATOR_ENABLED);
    }

    public int receiveBuf() {
        return this.rssConf.get(RssClientConf.NETTY_CLIENT_RECEIVE_BUFFER);
    }

    public int sendBuf() {
        return this.rssConf.get(RssClientConf.NETTY_CLIENT_SEND_BUFFER);
    }
}

