/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.web.resource;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hbase.thirdparty.javax.ws.rs.Consumes;
import org.apache.hbase.thirdparty.javax.ws.rs.DELETE;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.POST;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.PathParam;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.QueryParam;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.uniffle.common.Application;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.web.resource.Authorization;
import org.apache.uniffle.common.web.resource.BaseResource;
import org.apache.uniffle.common.web.resource.Response;
import org.apache.uniffle.coordinator.ApplicationManager;
import org.apache.uniffle.coordinator.ClusterManager;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.web.request.ApplicationRequest;
import org.apache.uniffle.coordinator.web.request.CancelDecommissionRequest;
import org.apache.uniffle.coordinator.web.request.DecommissionRequest;

@Produces(value={"application/json"})
public class ServerResource
extends BaseResource {
    @Context
    protected ServletContext servletContext;

    @GET
    @Path(value="/status")
    public Response<String> status() {
        return this.execute(() -> "success");
    }

    @GET
    @Path(value="/nodes/{id}")
    public Response<ServerNode> node(@PathParam(value="id") String id) {
        return this.execute(() -> this.getClusterManager().getServerNodeById(id));
    }

    @GET
    @Path(value="/nodes")
    public Response<List<ServerNode>> nodes(@QueryParam(value="status") String status) {
        List<ServerNode> serverList;
        ClusterManager clusterManager = this.getClusterManager();
        if (ServerStatus.UNHEALTHY.name().equalsIgnoreCase(status)) {
            serverList = clusterManager.getUnhealthyServerList();
        } else if (ServerStatus.LOST.name().equalsIgnoreCase(status)) {
            serverList = clusterManager.getLostServerList();
        } else if (ServerStatus.EXCLUDED.name().equalsIgnoreCase(status)) {
            serverList = clusterManager.list().stream().filter(node -> clusterManager.getExcludedNodes().contains(node.getId())).collect(Collectors.toList());
        } else {
            List<ServerNode> serverAllList = clusterManager.list();
            serverList = serverAllList.stream().filter(node -> !clusterManager.getExcludedNodes().contains(node.getId())).collect(Collectors.toList());
        }
        serverList = serverList.stream().filter(server -> status == null || server.getStatus().name().equalsIgnoreCase(status) || ServerStatus.EXCLUDED.name().equalsIgnoreCase(status)).collect(Collectors.toList());
        serverList.sort(Comparator.comparing(ServerNode::getId));
        return Response.success(serverList);
    }

    @Authorization
    @POST
    @Path(value="/cancelDecommission")
    public Response<Object> cancelDecommission(CancelDecommissionRequest params) {
        return this.execute(() -> {
            if (CollectionUtils.isEmpty(params.getServerIds())) {
                throw new RssException("Parameter[serverIds] should not be empty!");
            }
            params.getServerIds().forEach(this.getClusterManager()::cancelDecommission);
            return null;
        });
    }

    @Authorization
    @POST
    @Path(value="/{id}/cancelDecommission")
    public Response<Object> cancelDecommission(@PathParam(value="id") String serverId) {
        return this.execute(() -> {
            this.getClusterManager().cancelDecommission(serverId);
            return null;
        });
    }

    @Authorization
    @POST
    @Path(value="/decommission")
    public Response<Object> decommission(DecommissionRequest params) {
        return this.execute(() -> {
            if (CollectionUtils.isEmpty(params.getServerIds())) {
                throw new RssException("Parameter[serverIds] should not be empty!");
            }
            params.getServerIds().forEach(this.getClusterManager()::decommission);
            return null;
        });
    }

    @Authorization
    @POST
    @Path(value="/{id}/decommission")
    @Produces(value={"application/json"})
    public Response<Object> decommission(@PathParam(value="id") String serverId) {
        return this.execute(() -> {
            this.getClusterManager().decommission(serverId);
            return null;
        });
    }

    @POST
    @Path(value="/applications")
    @Produces(value={"application/json"})
    public Response<Object> application(ApplicationRequest params) {
        if (params == null) {
            return Response.fail((String)"ApplicationRequest Is not null");
        }
        HashSet<String> filterApplications = new HashSet();
        if (CollectionUtils.isNotEmpty(params.getApplications())) {
            filterApplications = params.getApplications();
        }
        int currentPage = params.getCurrentPage();
        int pageSize = params.getPageSize();
        String startTime = params.getHeartBeatStartTime();
        String endTime = params.getHeartBeatEndTime();
        String appIdRegex = params.getAppIdRegex();
        try {
            ApplicationManager applicationManager = this.getApplicationManager();
            List<Application> applicationSet = applicationManager.getApplications(filterApplications, pageSize, currentPage, startTime, endTime, appIdRegex);
            return Response.success(applicationSet);
        }
        catch (Exception e) {
            return Response.fail((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/nodes/summary")
    public Response<Map<String, Integer>> getNodeStatusTotal() {
        return this.execute(() -> {
            ClusterManager clusterManager = this.getClusterManager();
            List<ServerNode> serverAllList = clusterManager.list();
            List excludeNodes = clusterManager.getExcludedNodes().stream().map(ServerNode::new).collect(Collectors.toList());
            List activeServerList = serverAllList.stream().filter(node -> !clusterManager.getExcludedNodes().contains(node.getId())).collect(Collectors.toList());
            Map<String, Integer> serverStatusNum = Stream.of(activeServerList, clusterManager.getLostServerList(), excludeNodes, clusterManager.getUnhealthyServerList()).flatMap(Collection::stream).distinct().collect(Collectors.groupingBy(n -> n.getStatus().name(), Collectors.reducing(0, n -> 1, Integer::sum)));
            return serverStatusNum;
        });
    }

    @DELETE
    @Path(value="/deleteServer")
    public Response<String> handleDeleteLostServerRequest(@QueryParam(value="serverId") String serverId) {
        ClusterManager clusterManager = this.getClusterManager();
        if (clusterManager.deleteLostServerById(serverId)) {
            return Response.success((Object)"success");
        }
        return Response.fail((String)"fail");
    }

    @POST
    @Path(value="/addExcludeNodes")
    @Consumes(value={"application/json"})
    public Response<String> handleAddExcludedNodesRequest(Map<String, List<String>> excludeNodes) {
        ClusterManager clusterManager = this.getClusterManager();
        if (clusterManager.addExcludedNodes(excludeNodes.get("excludeNodes"))) {
            return Response.success((Object)"success");
        }
        return Response.fail((String)"fail");
    }

    @POST
    @Path(value="/removeExcludeNodes")
    @Consumes(value={"application/json"})
    public Response<String> handleDeleteExcludeNodesRequest(Map<String, List<String>> excludeNodes) {
        ClusterManager clusterManager = this.getClusterManager();
        if (clusterManager.removeExcludedNodesFromFile(excludeNodes.get("excludeNodes"))) {
            return Response.success((Object)"success");
        }
        return Response.fail((String)"fail");
    }

    private ClusterManager getClusterManager() {
        return (ClusterManager)this.servletContext.getAttribute(ClusterManager.class.getCanonicalName());
    }

    private ApplicationManager getApplicationManager() {
        return (ApplicationManager)this.servletContext.getAttribute(ApplicationManager.class.getCanonicalName());
    }
}

