/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.request;

import java.util.Collections;
import java.util.Map;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;

public class RssFetchClientConfRequest {
    private final int timeoutMs;
    private String user;
    private Map<String, String> properties = Collections.emptyMap();

    public RssFetchClientConfRequest(int timeoutMs, String user, Map<String, String> properties) {
        this.timeoutMs = timeoutMs;
        this.user = user;
        this.properties = properties;
    }

    @VisibleForTesting
    public RssFetchClientConfRequest(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.user = "";
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public String getUser() {
        return this.user;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public RssProtos.FetchClientConfRequest toProto() {
        return RssProtos.FetchClientConfRequest.newBuilder().setUser(this.user).putAllProperties(this.properties).build();
    }
}

