/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.storage;

import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.proto.RssProtos;

public enum StorageStatus {
    UNKNOWN(0),
    NORMAL(1),
    UNHEALTHY(2),
    OVERUSED(3);

    private final byte val;

    private StorageStatus(int code) {
        if (code < -1 || code >= 256) {
            throw new RssException("The code should be within [-1, 256)");
        }
        this.val = (byte)code;
    }

    public final byte getCode() {
        return this.val;
    }

    public RssProtos.StorageInfo.StorageStatus toProto() {
        switch (this) {
            case UNKNOWN: {
                return RssProtos.StorageInfo.StorageStatus.STORAGE_STATUS_UNKNOWN;
            }
            case NORMAL: {
                return RssProtos.StorageInfo.StorageStatus.NORMAL;
            }
            case UNHEALTHY: {
                return RssProtos.StorageInfo.StorageStatus.UNHEALTHY;
            }
            case OVERUSED: {
                return RssProtos.StorageInfo.StorageStatus.OVERUSED;
            }
        }
        return RssProtos.StorageInfo.StorageStatus.UNRECOGNIZED;
    }

    public static StorageStatus fromProto(RssProtos.StorageInfo.StorageStatus status) {
        switch (status) {
            case NORMAL: {
                return NORMAL;
            }
            case UNHEALTHY: {
                return UNHEALTHY;
            }
            case OVERUSED: {
                return OVERUSED;
            }
        }
        return UNKNOWN;
    }
}

