/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shuffle;

import java.util.function.Supplier;
import org.apache.uniffle.client.api.ShuffleManagerClient;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.client.impl.ShuffleWriteClientImpl;
import org.apache.uniffle.shuffle.BlockIdSelfManagedShuffleWriteClient;

public class RssShuffleClientFactory
extends ShuffleClientFactory {
    private static final RssShuffleClientFactory INSTANCE = new RssShuffleClientFactory();

    public static RssShuffleClientFactory getInstance() {
        return INSTANCE;
    }

    public ShuffleWriteClient createShuffleWriteClient(ExtendWriteClientBuilder builder) {
        return builder.build();
    }

    public static ExtendWriteClientBuilder<?> newWriteBuilder() {
        return new ExtendWriteClientBuilder();
    }

    public static class ExtendWriteClientBuilder<T extends ExtendWriteClientBuilder<T>>
    extends ShuffleClientFactory.WriteClientBuilder<T> {
        private boolean blockIdSelfManagedEnabled;
        private Supplier<ShuffleManagerClient> managerClientSupplier;

        public boolean isBlockIdSelfManagedEnabled() {
            return this.blockIdSelfManagedEnabled;
        }

        public Supplier<ShuffleManagerClient> getManagerClientSupplier() {
            return this.managerClientSupplier;
        }

        public T managerClientSupplier(Supplier<ShuffleManagerClient> managerClientSupplier) {
            this.managerClientSupplier = managerClientSupplier;
            return (T)((ExtendWriteClientBuilder)this.self());
        }

        public T blockIdSelfManagedEnabled(boolean blockIdSelfManagedEnabled) {
            this.blockIdSelfManagedEnabled = blockIdSelfManagedEnabled;
            return (T)((ExtendWriteClientBuilder)this.self());
        }

        @Override
        public ShuffleWriteClientImpl build() {
            if (this.blockIdSelfManagedEnabled) {
                return new BlockIdSelfManagedShuffleWriteClient(this);
            }
            return super.build();
        }
    }
}

