/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.uniffle.client.factory.CoordinatorClientFactory;
import org.apache.uniffle.client.impl.grpc.CoordinatorGrpcRetryableClient;
import org.apache.uniffle.client.request.RssSendHeartBeatRequest;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterHeartBeat {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterHeartBeat.class);
    private final long heartBeatInitialDelay;
    private final long heartBeatInterval;
    private final ShuffleServer shuffleServer;
    private final String coordinatorQuorum;
    private final CoordinatorGrpcRetryableClient coordinatorClient;
    private final ScheduledExecutorService service = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"startHeartBeat");

    public RegisterHeartBeat(ShuffleServer shuffleServer) {
        ShuffleServerConf conf = shuffleServer.getShuffleServerConf();
        this.heartBeatInitialDelay = conf.getLong(ShuffleServerConf.SERVER_HEARTBEAT_DELAY);
        this.heartBeatInterval = conf.getLong(ShuffleServerConf.SERVER_HEARTBEAT_INTERVAL);
        this.coordinatorQuorum = conf.getString(ShuffleServerConf.RSS_COORDINATOR_QUORUM);
        CoordinatorClientFactory factory = CoordinatorClientFactory.getInstance();
        this.coordinatorClient = factory.createCoordinatorClient((ClientType)conf.get(ShuffleServerConf.RSS_COORDINATOR_CLIENT_TYPE), this.coordinatorQuorum, 0L, 0, conf.getInteger(ShuffleServerConf.SERVER_HEARTBEAT_THREAD_NUM));
        this.shuffleServer = shuffleServer;
    }

    public void startHeartBeat() {
        LOG.info("Start heartbeat to coordinator {} after {}ms and interval is {}ms", new Object[]{this.coordinatorQuorum, this.heartBeatInitialDelay, this.heartBeatInterval});
        Runnable runnable = () -> {
            try {
                RssSendHeartBeatRequest request = new RssSendHeartBeatRequest(this.shuffleServer.getId(), this.shuffleServer.getIp(), this.shuffleServer.getGrpcPort(), this.shuffleServer.getUsedMemory(), this.shuffleServer.getPreAllocatedMemory(), this.shuffleServer.getAvailableMemory(), this.shuffleServer.getEventNumInFlush(), this.heartBeatInterval, this.shuffleServer.getTags(), this.shuffleServer.getServerStatus(), this.shuffleServer.getStorageManager().getStorageInfo(), this.shuffleServer.getNettyPort(), this.shuffleServer.getJettyPort(), this.shuffleServer.getStartTimeMs(), this.shuffleServer.getAppInfos(), this.shuffleServer.getDisplayMetrics());
                this.sendHeartBeat(request);
            }
            catch (Exception e) {
                LOG.warn("Error happened when send heart beat to coordinator");
            }
        };
        this.service.scheduleAtFixedRate(runnable, this.heartBeatInitialDelay, this.heartBeatInterval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public boolean sendHeartBeat(RssSendHeartBeatRequest request) {
        return this.coordinatorClient.sendHeartBeat(request).getStatusCode() == StatusCode.SUCCESS;
    }

    public long getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void shutdown() {
        this.coordinatorClient.close();
        this.service.shutdownNow();
    }
}

