/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.tez.common.IdUtils;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.CompositeInputAttemptIdentifier;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetchedInputAllocatorOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.RMRssShuffle;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleScheduler;

public class RMRssShuffleScheduler
extends ShuffleScheduler {
    private RMRssShuffle rssShuffle;

    public RMRssShuffleScheduler(InputContext inputContext, Configuration conf, int numberOfInputs, ExceptionReporter exceptionReporter, MergeManager mergeManager, FetchedInputAllocatorOrderedGrouped allocator, long startTime, CompressionCodec codec, boolean ifileReadAhead, int ifileReadAheadLength, String srcNameTrimmed, RMRssShuffle rssShuffle) throws IOException {
        super(inputContext, conf, numberOfInputs, exceptionReporter, mergeManager, allocator, startTime, codec, ifileReadAhead, ifileReadAheadLength, srcNameTrimmed);
        this.rssShuffle = rssShuffle;
    }

    public synchronized void addKnownMapOutput(String inputHostName, int port, int partitionId, CompositeInputAttemptIdentifier srcAttempt) {
        super.addKnownMapOutput(inputHostName, port, partitionId, srcAttempt);
        this.rssShuffle.partitionIds.add(partitionId);
        if (!this.rssShuffle.partitionIdToSuccessMapTaskAttempts.containsKey(partitionId)) {
            this.rssShuffle.partitionIdToSuccessMapTaskAttempts.put(partitionId, new HashSet());
        }
        this.rssShuffle.partitionIdToSuccessMapTaskAttempts.get(partitionId).add((InputAttemptIdentifier)srcAttempt);
        String pathComponent = srcAttempt.getPathComponent();
        TezTaskAttemptID tezTaskAttemptId = IdUtils.convertTezTaskAttemptID(pathComponent);
        if (!this.rssShuffle.partitionIdToSuccessTezTasks.containsKey(partitionId)) {
            this.rssShuffle.partitionIdToSuccessTezTasks.put(partitionId, new HashSet());
        }
        this.rssShuffle.partitionIdToSuccessTezTasks.get(partitionId).add(tezTaskAttemptId.getTaskID());
    }
}

