/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.RssTezUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.ProgressFailedException;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.readers.UnorderedKVReader;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.ShuffleEventHandler;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.impl.RssShuffleManager;
import org.apache.tez.runtime.library.common.shuffle.impl.RssSimpleFetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleInputEventHandlerImpl;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleManager;
import org.apache.tez.runtime.library.common.shuffle.impl.SimpleFetchedInputAllocator;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class RssUnorderedKVInput
extends AbstractLogicalInput {
    private static final Logger LOG = LoggerFactory.getLogger(RssUnorderedKVInput.class);
    private Configuration conf;
    private RssShuffleManager rssShuffleManager;
    private final BlockingQueue<Event> pendingEvents = new LinkedBlockingQueue<Event>();
    private long firstEventReceivedTime = -1L;
    private MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private UnorderedKVReader kvReader;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private TezCounter inputRecordCounter;
    private SimpleFetchedInputAllocator inputManager;
    private ShuffleEventHandler inputEventHandler;
    private int shuffleId;
    private ApplicationAttemptId applicationAttemptId;
    private static final Set<String> CONF_KEYS = new HashSet<String>();

    public RssUnorderedKVInput(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
    }

    public synchronized List<Event> initialize() throws Exception {
        LOG.info("RssUnorderedKVInput initialize\uff0c num of physicalInputs:{}", (Object)this.getNumPhysicalInputs());
        Preconditions.checkArgument(this.getNumPhysicalInputs() != -1, "Number of Inputs has not been set");
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        if (this.getNumPhysicalInputs() == 0) {
            this.getContext().requestInitialMemory(0L, null);
            this.isStarted.set(true);
            this.getContext().inputIsReady();
            LOG.info("input fetch not required since there are 0 physical inputs for input vertex: " + this.getContext().getSourceVertexName());
            return Collections.emptyList();
        }
        long initialMemReq = this.getInitialMemoryReq();
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        this.getContext().requestInitialMemory(initialMemReq, (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        this.conf.setStrings("tez.runtime.framework.local.dirs", this.getContext().getWorkDirs());
        this.inputRecordCounter = this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED);
        TezTaskAttemptID taskAttemptId = TezTaskAttemptID.fromString((String)RssTezUtils.uniqueIdentifierToAttemptId(this.getContext().getUniqueIdentifier()));
        TezVertexID tezVertexID = taskAttemptId.getTaskID().getVertexID();
        TezDAGID tezDAGID = tezVertexID.getDAGId();
        int sourceVertexId = this.conf.getInt("tez.rss.shuffle.source.vertex.id", -1);
        int destinationVertexId = this.conf.getInt("tez.rss.shuffle.destination.vertex.id", -1);
        if (sourceVertexId == -1) {
            throw new RssException("sourceVertexId should not be -1");
        }
        if (destinationVertexId == -1) {
            throw new RssException("destinationVertexId should not be -1");
        }
        this.shuffleId = RssTezUtils.computeShuffleId(tezDAGID.getId(), sourceVertexId, destinationVertexId);
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.getContext().getApplicationId(), (int)this.getContext().getDAGAttemptNumber());
        return Collections.emptyList();
    }

    public synchronized void start() throws IOException {
        if (!this.isStarted.get()) {
            CompressionCodec codec;
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            if (ConfigUtils.isIntermediateInputCompressed((Configuration)this.conf)) {
                Class codecClass = ConfigUtils.getIntermediateInputCompressorClass((Configuration)this.conf, DefaultCodec.class);
                codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)this.conf);
            } else {
                codec = null;
            }
            boolean ifileReadAhead = this.conf.getBoolean("tez.runtime.ifile.readahead", true);
            int ifileReadAheadLength = 0;
            int ifileBufferSize = 0;
            if (ifileReadAhead) {
                ifileReadAheadLength = this.conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000);
            }
            ifileBufferSize = this.conf.getInt("io.file.buffer.size", -1);
            LOG.info("RssUnorderedKVInput, totalMemoryAvailable:{}, available memory:{}", (Object)this.getContext().getTotalMemoryAvailableToTask(), (Object)this.memoryUpdateCallbackHandler.getMemoryAssigned());
            boolean compositeFetch = ShuffleUtils.isTezShuffleHandler((Configuration)this.conf);
            this.inputManager = new RssSimpleFetchedInputAllocator(TezUtilsInternal.cleanVertexName((String)this.getContext().getSourceVertexName()), this.getContext().getUniqueIdentifier(), this.getContext().getDagIdentifier(), this.conf, this.getContext().getTotalMemoryAvailableToTask(), this.memoryUpdateCallbackHandler.getMemoryAssigned(), this.applicationAttemptId.toString());
            this.rssShuffleManager = new RssShuffleManager(this.getContext(), this.conf, this.getNumPhysicalInputs(), ifileBufferSize, ifileReadAhead, ifileReadAheadLength, codec, (FetchedInputAllocator)this.inputManager, this.shuffleId, this.applicationAttemptId);
            this.inputEventHandler = new ShuffleInputEventHandlerImpl(this.getContext(), (ShuffleManager)this.rssShuffleManager, (FetchedInputAllocator)this.inputManager, codec, ifileReadAhead, ifileReadAheadLength, compositeFetch);
            this.rssShuffleManager.run();
            this.kvReader = this.createReader(this.inputRecordCounter, codec, ifileBufferSize, ifileReadAhead, ifileReadAheadLength);
            LinkedList pending = new LinkedList();
            this.pendingEvents.drainTo(pending);
            if (pending.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getContext().getSourceVertexName() + ": NoAutoStart delay in processing first event: " + (System.currentTimeMillis() - this.firstEventReceivedTime));
                }
                this.inputEventHandler.handleEvents(pending);
            }
            this.isStarted.set(true);
        }
    }

    public synchronized KeyValueReader getReader() throws Exception {
        Preconditions.checkState(this.isStarted.get(), "Must start input before invoking this method");
        if (this.getNumPhysicalInputs() == 0) {
            return new KeyValueReader(){

                public boolean next() throws IOException {
                    RssUnorderedKVInput.this.getContext().notifyProgress();
                    this.hasCompletedProcessing();
                    this.completedProcessing = true;
                    return false;
                }

                public Object getCurrentKey() throws IOException {
                    throw new RssException("No data available in Input");
                }

                public Object getCurrentValue() throws IOException {
                    throw new RssException("No data available in Input");
                }
            };
        }
        return this.kvReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List<Event> inputEvents) throws IOException {
        ShuffleEventHandler inputEventHandlerLocalRef;
        RssUnorderedKVInput rssUnorderedKVInput = this;
        synchronized (rssUnorderedKVInput) {
            if (this.getNumPhysicalInputs() == 0) {
                throw new RssException("No input events expected as numInputs is 0");
            }
            if (!this.isStarted.get()) {
                if (this.firstEventReceivedTime == -1L) {
                    this.firstEventReceivedTime = System.currentTimeMillis();
                }
                this.pendingEvents.addAll(inputEvents);
                return;
            }
            inputEventHandlerLocalRef = this.inputEventHandler;
        }
        inputEventHandlerLocalRef.handleEvents(inputEvents);
    }

    public synchronized List<Event> close() throws Exception {
        if (this.inputEventHandler != null) {
            this.inputEventHandler.logProgress(true);
        }
        if (this.rssShuffleManager != null) {
            this.rssShuffleManager.shutdown();
        }
        long dataSize = this.getContext().getCounters().findCounter((Enum)TaskCounter.SHUFFLE_BYTES_DECOMPRESSED).getValue();
        this.getContext().getStatisticsReporter().reportDataSize(dataSize);
        long inputRecords = this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED).getValue();
        this.getContext().getStatisticsReporter().reportItemsProcessed(inputRecords);
        return null;
    }

    private long getInitialMemoryReq() {
        return SimpleFetchedInputAllocator.getInitialMemoryReq((Configuration)this.conf, (long)this.getContext().getTotalMemoryAvailableToTask());
    }

    private UnorderedKVReader createReader(TezCounter inputRecordCounter, CompressionCodec codec, int ifileBufferSize, boolean ifileReadAheadEnabled, int ifileReadAheadLength) throws IOException {
        return new UnorderedKVReader((ShuffleManager)this.rssShuffleManager, this.conf, null, ifileReadAheadEnabled, 0, ifileBufferSize, inputRecordCounter, this.getContext());
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(CONF_KEYS);
    }

    public float getProgress() throws ProgressFailedException, InterruptedException {
        try {
            return this.kvReader.getProgress();
        }
        catch (IOException e) {
            throw new ProgressFailedException("getProgress encountered IOException ", (Throwable)e);
        }
    }

    static {
        CONF_KEYS.add("tez.runtime.ifile.readahead");
        CONF_KEYS.add("tez.runtime.ifile.readahead.bytes");
        CONF_KEYS.add("io.file.buffer.size");
        CONF_KEYS.add("tez.runtime.io.sort.factor");
        CONF_KEYS.add("tez.runtime.shuffle.use.async.http");
        CONF_KEYS.add("tez.runtime.shuffle.parallel.copies");
        CONF_KEYS.add("tez.runtime.shuffle.fetch.failures.limit");
        CONF_KEYS.add("tez.runtime.shuffle.fetch.max.task.output.at.once");
        CONF_KEYS.add("tez.runtime.shuffle.notify.readerror");
        CONF_KEYS.add("tez.runtime.shuffle.connect.timeout");
        CONF_KEYS.add("tez.runtime.shuffle.keep-alive.enabled");
        CONF_KEYS.add("tez.runtime.shuffle.keep-alive.max.connections");
        CONF_KEYS.add("tez.runtime.shuffle.read.timeout");
        CONF_KEYS.add("tez.runtime.shuffle.buffersize");
        CONF_KEYS.add("tez.runtime.shuffle.ssl.enable");
        CONF_KEYS.add("tez.runtime.shuffle.fetch.verify-disk-checksum");
        CONF_KEYS.add("tez.runtime.shuffle.fetch.buffer.percent");
        CONF_KEYS.add("tez.runtime.shuffle.memory.limit.percent");
        CONF_KEYS.add("tez.runtime.shuffle.merge.percent");
        CONF_KEYS.add("tez.runtime.shuffle.fetcher.use-shared-pool");
        CONF_KEYS.add("tez.runtime.task.input.post-merge.buffer.percent");
        CONF_KEYS.add("tez.runtime.key.class");
        CONF_KEYS.add("tez.runtime.value.class");
        CONF_KEYS.add("tez.runtime.compress");
        CONF_KEYS.add("tez.runtime.compress.codec");
        CONF_KEYS.add("tez.runtime.optimize.local.fetch");
        CONF_KEYS.add("tez.runtime.optimize.shared.fetch");
        CONF_KEYS.add("tez.runtime.convert.user-payload.to.history-text");
        CONF_KEYS.add("tez.counters.max");
        CONF_KEYS.add("tez.counters.group-name.max-length");
        CONF_KEYS.add("tez.counters.counter-name.max-length");
        CONF_KEYS.add("tez.counters.max.groups");
        CONF_KEYS.add("tez.runtime.cleanup.files.on.interrupt");
        CONF_KEYS.add("tez.runtime.task.memory");
        CONF_KEYS.add("tez.am.shuffle.auxiliary-service.id");
    }
}

