/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import org.apache.uniffle.common.ShufflePartitionedBlock;

public class ShufflePartitionedData {
    private static final ShufflePartitionedBlock[] EMPTY_BLOCK_LIST = new ShufflePartitionedBlock[0];
    private int partitionId;
    private final ShufflePartitionedBlock[] blockList;
    private final long totalBlockEncodedLength;
    private final long totalBlockDataLength;

    public ShufflePartitionedData(int partitionId, long encodedLength, long dataLength, ShufflePartitionedBlock[] blockList) {
        this.partitionId = partitionId;
        this.blockList = blockList == null ? EMPTY_BLOCK_LIST : blockList;
        this.totalBlockEncodedLength = encodedLength;
        this.totalBlockDataLength = dataLength;
    }

    @VisibleForTesting
    public ShufflePartitionedData(int partitionId, ShufflePartitionedBlock[] blockList) {
        this.partitionId = partitionId;
        this.blockList = blockList == null ? EMPTY_BLOCK_LIST : blockList;
        long encodedLength = 0L;
        long dataLength = 0L;
        for (ShufflePartitionedBlock block : this.blockList) {
            encodedLength += block.getEncodedLength();
            dataLength += (long)block.getDataLength();
        }
        this.totalBlockEncodedLength = encodedLength;
        this.totalBlockDataLength = dataLength;
    }

    public String toString() {
        return "ShufflePartitionedData{partitionId=" + this.partitionId + ", blockList=" + Arrays.toString(this.blockList) + '}';
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public ShufflePartitionedBlock[] getBlockList() {
        return this.blockList;
    }

    public long getTotalBlockEncodedLength() {
        return this.totalBlockEncodedLength;
    }

    public long getTotalBlockDataLength() {
        return this.totalBlockDataLength;
    }
}

