/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.records;

import java.io.IOException;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.serializer.SerializationStream;
import org.apache.uniffle.common.serializer.Serializer;
import org.apache.uniffle.common.serializer.SerializerFactory;
import org.apache.uniffle.common.serializer.SerializerInstance;

public class RecordsWriter<K, V> {
    private SerializationStream stream;

    public RecordsWriter(RssConf rssConf, SerOutputStream out, Class keyClass, Class valueClass, boolean raw, boolean buffered) {
        SerializerFactory factory = new SerializerFactory(rssConf);
        Serializer serializer = factory.getSerializer(keyClass);
        assert (factory.getSerializer(valueClass).getClass().equals(serializer.getClass()));
        SerializerInstance instance = serializer.newInstance();
        this.stream = instance.serializeStream(out, raw, buffered);
    }

    public void init() {
        this.stream.init();
    }

    public void append(Object key, Object value) throws IOException {
        this.stream.writeRecord(key, value);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    public long getTotalBytesWritten() {
        return this.stream.getTotalBytesWritten();
    }
}

