/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.unomi.router.api.ImportLineError;
import org.apache.unomi.router.api.exceptions.BadProfileDataFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineSplitFailureHandler
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)LineSplitFailureHandler.class.getName());

    public void process(Exchange exchange) throws Exception {
        LOGGER.error("Route: {}, Error: {}", exchange.getProperty("CamelFailureRouteId"), exchange.getProperty("CamelExceptionCaught"));
        ImportLineError importLineError = new ImportLineError();
        if (exchange.getProperty("CamelExceptionCaught") instanceof BadProfileDataFormatException) {
            importLineError.setErrorCode(((BadProfileDataFormatException)exchange.getProperty("CamelExceptionCaught")).getCause().getMessage());
        } else if (exchange.getProperty("CamelExceptionCaught") instanceof Throwable) {
            Throwable rootCause = (Throwable)exchange.getProperty("CamelExceptionCaught");
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            importLineError.setErrorCode(rootCause.getMessage());
        } else {
            importLineError.setErrorCode(exchange.getProperty("CamelExceptionCaught").toString());
        }
        importLineError.setLineContent((String)exchange.getIn().getBody(String.class));
        importLineError.setLineNb((long)((Integer)exchange.getProperty("CamelSplitIndex") + 1));
        exchange.getIn().setHeader("failedMessage", (Object)Boolean.TRUE);
        exchange.getIn().setBody((Object)importLineError, ImportLineError.class);
    }
}

