/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONException;
import com.github.openjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxRequestTargetListenerCollection;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.attributes.AjaxAttributeName;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.attributes.IAjaxCallListener;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.json.JSONFunction;
import org.apache.wicket.ajax.json.JsonUtils;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.IComponentAwareHeaderContributor;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDefaultAjaxBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDefaultAjaxBehavior.class);
    public static final ResourceReference INDICATOR = new PackageResourceReference(AbstractDefaultAjaxBehavior.class, "indicator.gif");
    private static final String DYNAMIC_PARAMETER_FUNCTION_SIGNATURE = "function(attrs)";
    private static final String PRECONDITION_FUNCTION_SIGNATURE = "function(attrs)";
    private static final String COMPLETE_HANDLER_FUNCTION_SIGNATURE = "function(attrs, jqXHR, textStatus)";
    private static final String FAILURE_HANDLER_FUNCTION_SIGNATURE = "function(attrs, jqXHR, errorMessage, textStatus)";
    private static final String SUCCESS_HANDLER_FUNCTION_SIGNATURE = "function(attrs, jqXHR, data, textStatus)";
    private static final String AFTER_HANDLER_FUNCTION_SIGNATURE = "function(attrs)";
    private static final String BEFORE_SEND_HANDLER_FUNCTION_SIGNATURE = "function(attrs, jqXHR, settings)";
    private static final String BEFORE_HANDLER_FUNCTION_SIGNATURE = "function(attrs)";
    private static final String INIT_HANDLER_FUNCTION_SIGNATURE = "function(attrs)";
    private static final String DONE_HANDLER_FUNCTION_SIGNATURE = "function(attrs)";

    @Override
    protected void onBind() {
        Component component = this.getComponent();
        component.setOutputMarkupId(true);
        if (this.getStatelessHint(component)) {
            component.getBehaviorId(this);
        }
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        CoreLibrariesContributor.contributeAjax(component.getApplication(), response);
        RequestCycle requestCycle = component.getRequestCycle();
        Url baseUrl = requestCycle.getUrlRenderer().getBaseUrl();
        CharSequence ajaxBaseUrl = Strings.escapeMarkup((CharSequence)baseUrl.toString());
        response.render(JavaScriptHeaderItem.forScript("Wicket.Ajax.baseUrl=\"" + String.valueOf(ajaxBaseUrl) + "\";", "wicket-ajax-base-url"));
        this.renderExtraHeaderContributors(component, response);
    }

    private void renderExtraHeaderContributors(Component component, IHeaderResponse response) {
        AjaxRequestAttributes attributes = this.getAttributes();
        List<IAjaxCallListener> ajaxCallListeners = attributes.getAjaxCallListeners();
        for (IAjaxCallListener ajaxCallListener : ajaxCallListeners) {
            if (!(ajaxCallListener instanceof IComponentAwareHeaderContributor)) continue;
            IComponentAwareHeaderContributor contributor = (IComponentAwareHeaderContributor)((Object)ajaxCallListener);
            contributor.renderHead(component, response);
        }
    }

    protected final AjaxRequestAttributes getAttributes() {
        AjaxRequestAttributes attributes = new AjaxRequestAttributes();
        WebApplication application = (WebApplication)this.getComponent().getApplication();
        AjaxRequestTargetListenerCollection ajaxRequestTargetListeners = application.getAjaxRequestTargetListeners();
        Iterator iterator = ajaxRequestTargetListeners.iterator();
        while (iterator.hasNext()) {
            AjaxRequestTarget.IListener listener = (AjaxRequestTarget.IListener)iterator.next();
            listener.updateAjaxAttributes(this, attributes);
        }
        this.updateAjaxAttributes(attributes);
        return attributes;
    }

    protected Form.MethodMismatchResponse onMethodMismatch() {
        return Form.MethodMismatchResponse.CONTINUE;
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    protected final CharSequence renderAjaxAttributes(Component component) {
        AjaxRequestAttributes attributes = this.getAttributes();
        return this.renderAjaxAttributes(component, attributes);
    }

    protected final CharSequence renderAjaxAttributes(Component component, AjaxRequestAttributes attributes) {
        JSONObject attributesJson = new JSONObject();
        try {
            ThrottlingSettings throttlingSettings;
            String dataType;
            boolean wicketAjaxResponse;
            String[] eventNames;
            List<CharSequence> dynamicExtraParameters;
            String indicatorId;
            CharSequence childSelector;
            String submittingComponentId;
            String formId;
            attributesJson.put(AjaxAttributeName.URL.jsonName(), (Object)this.getCallbackUrl());
            AjaxRequestAttributes.Method method = attributes.getMethod();
            if (AjaxRequestAttributes.Method.POST == method) {
                attributesJson.put(AjaxAttributeName.METHOD.jsonName(), (Object)method);
            }
            if (!(component instanceof Page)) {
                String componentId = component.getMarkupId();
                attributesJson.put(AjaxAttributeName.MARKUP_ID.jsonName(), (Object)componentId);
            }
            if (!Strings.isEmpty((String)(formId = attributes.getFormId()))) {
                attributesJson.put(AjaxAttributeName.FORM_ID.jsonName(), (Object)formId);
            }
            if (attributes.isMultipart()) {
                attributesJson.put(AjaxAttributeName.IS_MULTIPART.jsonName(), true);
            }
            if (!Strings.isEmpty((String)(submittingComponentId = attributes.getSubmittingComponentName()))) {
                attributesJson.put(AjaxAttributeName.SUBMITTING_COMPONENT_NAME.jsonName(), (Object)submittingComponentId);
            }
            if (!Strings.isEmpty((CharSequence)(childSelector = attributes.getChildSelector()))) {
                attributesJson.put(AjaxAttributeName.CHILD_SELECTOR.jsonName(), (Object)childSelector);
            }
            if (attributes.isSerializeRecursively()) {
                attributesJson.put(AjaxAttributeName.SERIALIZE_RECURSIVELY.jsonName(), true);
            }
            if (!Strings.isEmpty((String)(indicatorId = this.findIndicatorId()))) {
                attributesJson.put(AjaxAttributeName.INDICATOR_ID.jsonName(), (Object)indicatorId);
            }
            for (IAjaxCallListener ajaxCallListener : attributes.getAjaxCallListeners()) {
                if (ajaxCallListener == null) continue;
                CharSequence initHandler = ajaxCallListener.getInitHandler(component);
                this.appendListenerHandler(initHandler, attributesJson, AjaxAttributeName.INIT_HANDLER.jsonName(), "function(attrs)");
                CharSequence charSequence = ajaxCallListener.getBeforeHandler(component);
                this.appendListenerHandler(charSequence, attributesJson, AjaxAttributeName.BEFORE_HANDLER.jsonName(), "function(attrs)");
                CharSequence beforeSendHandler = ajaxCallListener.getBeforeSendHandler(component);
                this.appendListenerHandler(beforeSendHandler, attributesJson, AjaxAttributeName.BEFORE_SEND_HANDLER.jsonName(), BEFORE_SEND_HANDLER_FUNCTION_SIGNATURE);
                CharSequence afterHandler = ajaxCallListener.getAfterHandler(component);
                this.appendListenerHandler(afterHandler, attributesJson, AjaxAttributeName.AFTER_HANDLER.jsonName(), "function(attrs)");
                CharSequence successHandler = ajaxCallListener.getSuccessHandler(component);
                this.appendListenerHandler(successHandler, attributesJson, AjaxAttributeName.SUCCESS_HANDLER.jsonName(), SUCCESS_HANDLER_FUNCTION_SIGNATURE);
                CharSequence failureHandler = ajaxCallListener.getFailureHandler(component);
                this.appendListenerHandler(failureHandler, attributesJson, AjaxAttributeName.FAILURE_HANDLER.jsonName(), FAILURE_HANDLER_FUNCTION_SIGNATURE);
                CharSequence completeHandler = ajaxCallListener.getCompleteHandler(component);
                this.appendListenerHandler(completeHandler, attributesJson, AjaxAttributeName.COMPLETE_HANDLER.jsonName(), COMPLETE_HANDLER_FUNCTION_SIGNATURE);
                CharSequence precondition = ajaxCallListener.getPrecondition(component);
                this.appendListenerHandler(precondition, attributesJson, AjaxAttributeName.PRECONDITION.jsonName(), "function(attrs)");
                CharSequence doneHandler = ajaxCallListener.getDoneHandler(component);
                this.appendListenerHandler(doneHandler, attributesJson, AjaxAttributeName.DONE_HANDLER.jsonName(), "function(attrs)");
            }
            JSONArray extraParameters = JsonUtils.asArray(attributes.getExtraParameters());
            if (extraParameters.length() > 0) {
                attributesJson.put(AjaxAttributeName.EXTRA_PARAMETERS.jsonName(), (Object)extraParameters);
            }
            if ((dynamicExtraParameters = attributes.getDynamicExtraParameters()) != null) {
                for (CharSequence charSequence : dynamicExtraParameters) {
                    JSONFunction function = this.getJsonFunction("function(attrs)", charSequence);
                    attributesJson.append(AjaxAttributeName.DYNAMIC_PARAMETER_FUNCTION.jsonName(), (Object)function);
                }
            }
            if (!attributes.isAsynchronous()) {
                attributesJson.put(AjaxAttributeName.IS_ASYNC.jsonName(), false);
            }
            if ((eventNames = attributes.getEventNames()).length == 1) {
                attributesJson.put(AjaxAttributeName.EVENT_NAME.jsonName(), (Object)eventNames[0]);
            } else {
                for (String eventName : eventNames) {
                    attributesJson.append(AjaxAttributeName.EVENT_NAME.jsonName(), (Object)eventName);
                }
            }
            AjaxChannel ajaxChannel = attributes.getChannel();
            if (ajaxChannel != null && !ajaxChannel.equals(AjaxChannel.DEFAULT)) {
                attributesJson.put(AjaxAttributeName.CHANNEL.jsonName(), (Object)ajaxChannel);
            }
            if (attributes.isPreventDefault()) {
                attributesJson.put(AjaxAttributeName.IS_PREVENT_DEFAULT.jsonName(), true);
            }
            if (AjaxRequestAttributes.EventPropagation.STOP.equals((Object)attributes.getEventPropagation())) {
                attributesJson.put(AjaxAttributeName.EVENT_PROPAGATION.jsonName(), (Object)"stop");
            } else if (AjaxRequestAttributes.EventPropagation.STOP_IMMEDIATE.equals((Object)attributes.getEventPropagation())) {
                attributesJson.put(AjaxAttributeName.EVENT_PROPAGATION.jsonName(), (Object)"stopImmediate");
            }
            Duration requestTimeout = attributes.getRequestTimeout();
            if (requestTimeout != null) {
                attributesJson.put(AjaxAttributeName.REQUEST_TIMEOUT.jsonName(), requestTimeout.toMillis());
            }
            if (!(wicketAjaxResponse = attributes.isWicketAjaxResponse())) {
                attributesJson.put(AjaxAttributeName.IS_WICKET_AJAX_RESPONSE.jsonName(), false);
            }
            if (!"xml".equals(dataType = attributes.getDataType())) {
                attributesJson.put(AjaxAttributeName.DATATYPE.jsonName(), (Object)dataType);
            }
            if ((throttlingSettings = attributes.getThrottlingSettings()) != null) {
                JSONObject throttlingSettingsJson = new JSONObject();
                String throttleId = throttlingSettings.getId();
                if (throttleId == null) {
                    throttleId = component.getMarkupId();
                }
                throttlingSettingsJson.put(AjaxAttributeName.THROTTLING_ID.jsonName(), (Object)throttleId);
                throttlingSettingsJson.put(AjaxAttributeName.THROTTLING_DELAY.jsonName(), throttlingSettings.getDelay().toMillis());
                if (throttlingSettings.getPostponeTimerOnUpdate()) {
                    throttlingSettingsJson.put(AjaxAttributeName.THROTTLING_POSTPONE_ON_UPDATE.jsonName(), true);
                }
                attributesJson.put(AjaxAttributeName.THROTTLING.jsonName(), (Object)throttlingSettingsJson);
            }
            this.postprocessConfiguration(attributesJson, component);
        }
        catch (JSONException e) {
            throw new WicketRuntimeException(e);
        }
        String attributesAsJson = attributesJson.toString();
        return attributesAsJson;
    }

    private void appendListenerHandler(CharSequence handler, JSONObject attributesJson, String propertyName, String signature) throws JSONException {
        if (!Strings.isEmpty((CharSequence)handler)) {
            JSONFunction function = handler instanceof JSONFunction ? (JSONFunction)handler : this.getJsonFunction(signature, handler);
            attributesJson.append(propertyName, (Object)function);
        }
    }

    private JSONFunction getJsonFunction(String signature, CharSequence body) {
        String func = signature + "{" + String.valueOf(body) + "}";
        return new JSONFunction(func);
    }

    protected void postprocessConfiguration(JSONObject attributesJson, Component component) throws JSONException {
    }

    public CharSequence getCallbackScript() {
        return this.getCallbackScript(this.getComponent());
    }

    protected CharSequence getCallbackScript(Component component) {
        CharSequence ajaxAttributes = this.renderAjaxAttributes(component);
        return "Wicket.Ajax.ajax(" + String.valueOf(ajaxAttributes) + ");";
    }

    public CharSequence getCallbackFunction(CallbackParameter ... extraParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("function (");
        boolean first = true;
        for (CallbackParameter curExtraParameter : extraParameters) {
            if (curExtraParameter.getFunctionParameterName() == null) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(curExtraParameter.getFunctionParameterName());
        }
        sb.append(") {\n");
        sb.append(this.getCallbackFunctionBody(extraParameters));
        sb.append("}\n");
        return sb;
    }

    public CharSequence getCallbackFunctionBody(CallbackParameter ... extraParameters) {
        AjaxRequestAttributes attributes = this.getAttributes();
        attributes.setEventNames(new String[0]);
        CharSequence attrsJson = this.renderAjaxAttributes(this.getComponent(), attributes);
        StringBuilder sb = new StringBuilder();
        sb.append("var attrs = ");
        sb.append(attrsJson);
        sb.append(";\n");
        JSONArray jsonArray = new JSONArray();
        for (CallbackParameter curExtraParameter : extraParameters) {
            if (curExtraParameter.getAjaxParameterName() == null) continue;
            try {
                JSONObject object = new JSONObject();
                object.put("name", (Object)curExtraParameter.getAjaxParameterName());
                object.put("value", (Object)new JSONFunction(curExtraParameter.getAjaxParameterCode()));
                jsonArray.put((Object)object);
            }
            catch (JSONException e) {
                throw new WicketRuntimeException(e);
            }
        }
        sb.append("var params = ").append(jsonArray).append(";\n");
        sb.append("attrs.").append((Object)AjaxAttributeName.EXTRA_PARAMETERS).append(" = params.concat(attrs.").append((Object)AjaxAttributeName.EXTRA_PARAMETERS).append(" || []);\n");
        sb.append("Wicket.Ajax.ajax(attrs);\n");
        return sb;
    }

    protected String findIndicatorId() {
        if (this.getComponent() instanceof IAjaxIndicatorAware) {
            return ((IAjaxIndicatorAware)((Object)this.getComponent())).getAjaxIndicatorMarkupId();
        }
        if (this instanceof IAjaxIndicatorAware) {
            return ((IAjaxIndicatorAware)((Object)this)).getAjaxIndicatorMarkupId();
        }
        for (MarkupContainer parent = this.getComponent().getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof IAjaxIndicatorAware)) continue;
            return ((IAjaxIndicatorAware)((Object)parent)).getAjaxIndicatorMarkupId();
        }
        return null;
    }

    @Override
    public final void onRequest() {
        String actualMethod;
        AjaxRequestAttributes attrs;
        String desiredMethod;
        Form.MethodMismatchResponse methodMismatch = this.onMethodMismatch();
        if (methodMismatch == Form.MethodMismatchResponse.ABORT && !(desiredMethod = (attrs = this.getAttributes()).getMethod().toString()).equalsIgnoreCase(actualMethod = ((HttpServletRequest)RequestCycle.get().getRequest().getContainerRequest()).getMethod())) {
            LOG.debug("Ignoring the Ajax request because its method '{}' is different than the expected one '{}", (Object)actualMethod, (Object)desiredMethod);
            return;
        }
        WebApplication app = (WebApplication)this.getComponent().getApplication();
        AjaxRequestTarget target = app.newAjaxRequestTarget(this.getComponent().getPage());
        RequestCycle requestCycle = RequestCycle.get();
        requestCycle.scheduleRequestHandlerAfterCurrent(target);
        this.respond(target);
    }

    protected abstract void respond(AjaxRequestTarget var1);
}

