/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;

public class ClassEditor {
    private static final boolean DEBUG = false;
    private ProgramClass targetClass;

    public ClassEditor(ProgramClass targetClass) {
        this.targetClass = targetClass;
    }

    public void addInterface(int interfaceConstantIndex) {
        int[] interfaces = this.targetClass.u2interfaces;
        int interfacesCount = this.targetClass.u2interfacesCount;
        if (interfaces.length <= interfacesCount) {
            this.targetClass.u2interfaces = new int[interfacesCount + 1];
            System.arraycopy(interfaces, 0, this.targetClass.u2interfaces, 0, interfacesCount);
            interfaces = this.targetClass.u2interfaces;
        }
        interfaces[this.targetClass.u2interfacesCount++] = interfaceConstantIndex;
    }

    public void removeInterface(int interfaceConstantIndex) {
        int interfacesCount = this.targetClass.u2interfacesCount--;
        int[] interfaces = this.targetClass.u2interfaces;
        int interfaceIndex = this.findInterfaceIndex(interfaceConstantIndex);
        System.arraycopy(interfaces, interfaceIndex + 1, interfaces, interfaceIndex, interfacesCount - interfaceIndex - 1);
        interfaces[this.targetClass.u2interfacesCount] = 0;
    }

    private int findInterfaceIndex(int interfaceConstantIndex) {
        int interfacesCount = this.targetClass.u2interfacesCount;
        int[] interfaces = this.targetClass.u2interfaces;
        for (int index = 0; index < interfacesCount; ++index) {
            if (interfaces[index] != interfaceConstantIndex) continue;
            return index;
        }
        return interfacesCount;
    }

    public void addField(Field field) {
        ProgramField[] fields = this.targetClass.fields;
        int fieldsCount = this.targetClass.u2fieldsCount;
        if (fields.length <= fieldsCount) {
            this.targetClass.fields = new ProgramField[fieldsCount + 1];
            System.arraycopy(fields, 0, this.targetClass.fields, 0, fieldsCount);
            fields = this.targetClass.fields;
        }
        fields[this.targetClass.u2fieldsCount++] = field;
    }

    public void removeField(Field field) {
        int fieldsCount = this.targetClass.u2fieldsCount--;
        ProgramField[] fields = this.targetClass.fields;
        int fieldIndex = this.findFieldIndex(field);
        System.arraycopy(fields, fieldIndex + 1, fields, fieldIndex, fieldsCount - fieldIndex - 1);
        fields[this.targetClass.u2fieldsCount] = null;
    }

    private int findFieldIndex(Field field) {
        int fieldsCount = this.targetClass.u2fieldsCount;
        ProgramField[] fields = this.targetClass.fields;
        for (int index = 0; index < fieldsCount; ++index) {
            if (!fields[index].equals(field)) continue;
            return index;
        }
        return fieldsCount;
    }

    public void addMethod(Method method) {
        ProgramMethod[] methods = this.targetClass.methods;
        int methodsCount = this.targetClass.u2methodsCount;
        if (methods.length <= methodsCount) {
            this.targetClass.methods = new ProgramMethod[methodsCount + 1];
            System.arraycopy(methods, 0, this.targetClass.methods, 0, methodsCount);
            methods = this.targetClass.methods;
        }
        methods[this.targetClass.u2methodsCount++] = method;
    }

    public void removeMethod(Method method) {
        int methodsCount = this.targetClass.u2methodsCount--;
        ProgramMethod[] methods = this.targetClass.methods;
        int methodIndex = this.findMethodIndex(method);
        System.arraycopy(methods, methodIndex + 1, methods, methodIndex, methodsCount - methodIndex - 1);
        methods[this.targetClass.u2methodsCount] = null;
    }

    private int findMethodIndex(Method method) {
        int methodsCount = this.targetClass.u2methodsCount;
        ProgramMethod[] methods = this.targetClass.methods;
        for (int index = 0; index < methodsCount; ++index) {
            if (!methods[index].equals(method)) continue;
            return index;
        }
        return methodsCount;
    }
}

