/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.TestURLLoader;
import io.mola.galimatias.URL;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.ParameterSupplier;
import org.junit.experimental.theories.ParametersSuppliedBy;
import org.junit.experimental.theories.PotentialAssignment;

public class TestURL {
    public String rawURL;
    public String rawBaseURL;
    public URL parsedURL;
    public URL parsedBaseURL;

    public String toString() {
        return String.format("TestURL(rawURL=%s, rawBaseURL=%s, parsedURL=%s, parsedBaseURL=%s)", this.rawURL, this.rawBaseURL, this.parsedURL, this.parsedBaseURL);
    }

    public static class TestURLSupplier
    extends ParameterSupplier {
        private static final Map<String, List<TestURL>> datasetMap = new HashMap<String, List<TestURL>>();

        public List<PotentialAssignment> getValueSources(ParameterSignature sig) {
            TestURLs ref = (TestURLs)sig.getAnnotation(TestURLs.class);
            String dataset = ref.dataset();
            if (!datasetMap.containsKey(dataset)) {
                datasetMap.put(dataset, TestURLLoader.loadTestURLs(dataset));
            }
            ArrayList<PotentialAssignment> values = new ArrayList<PotentialAssignment>();
            for (TestURL testURL : datasetMap.get(dataset)) {
                values.add(PotentialAssignment.forValue((String)testURL.toString(), (Object)testURL));
            }
            return values;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @ParametersSuppliedBy(value=TestURLSupplier.class)
    public static @interface TestURLs {
        public String dataset();
    }

    public abstract class DATASETS {
        public static final String WHATWG = "/data/urltestdata_whatwg.txt";
        public static final String HOST_WHATWG = "/data/urltestdata_host_whatwg.txt";
    }
}

