/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.gui.icon.button.CloseIcon;

public class CloseOthersWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final CloseOthersWindowAction INSTANCE = new CloseOthersWindowAction();
    private static final Icon icon = new CloseIcon(10);

    private CloseOthersWindowAction() {
    }

    @Override
    public Icon getIcon() {
        return icon;
    }

    @Override
    public String getName() {
        return "Close Others";
    }

    @Override
    public boolean isPerformable(DockingWindow window) {
        return window.getWindowParent() instanceof AbstractTabWindow;
    }

    @Override
    public void perform(DockingWindow window) {
        if (this.isPerformable(window)) {
            AbstractTabWindow tw = (AbstractTabWindow)window.getWindowParent();
            int i = 0;
            while (i < tw.getChildWindowCount()) {
                if (tw.getChildWindow(i) != window && tw.getChildWindow(i).isClosable()) {
                    try {
                        tw.getChildWindow(i).closeWithAbort();
                    }
                    catch (OperationAbortedException e) {
                        ++i;
                    }
                    continue;
                }
                ++i;
            }
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

