/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

class ColoredIconCreator {
    private final Map<Color, Icon> coloredNoteIcons;
    private final Image originalImage;
    private final Color replacedColor;

    public ColoredIconCreator(Image originalImage, Color replacedColor) {
        this.replacedColor = replacedColor;
        this.coloredNoteIcons = new HashMap<Color, Icon>();
        this.originalImage = originalImage;
    }

    private BufferedImage copy(Image img) {
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public Icon createColoredIcon(Color iconColor) {
        Icon icon = this.coloredNoteIcons.get(iconColor);
        if (icon == null && this.originalImage != null) {
            icon = new ImageIcon(this.createColoredImage(iconColor));
            this.coloredNoteIcons.put(iconColor, icon);
        }
        return icon;
    }

    public Image createColoredImage(Color newColor) {
        int newRGB = 0xFFFFFF & newColor.getRGB();
        if (!this.replacedColor.equals(newColor) && this.originalImage != null) {
            BufferedImage img = this.copy(this.originalImage);
            int width = img.getWidth();
            for (int x = 0; x < width; ++x) {
                int height = img.getHeight();
                for (int y = 0; y < height; ++y) {
                    int rgb = img.getRGB(x, y);
                    if (!this.shouldReplace(rgb)) continue;
                    img.setRGB(x, y, 0xFF000000 | newRGB);
                }
            }
            return img;
        }
        return this.originalImage;
    }

    private boolean shouldReplace(int rgb) {
        return (rgb >> 16 & 0xFF) != 0;
    }
}

