/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.main.application.ColoredIconCreator;

class IconColorReplacer {
    private final List<Image> originalIconImages;
    final Map<Color, List<Image>> derivedImages;
    private static final Color original = ColorUtils.stringToColor((String)"#ffffff");
    private static final Color red = ColorUtils.stringToColor((String)"#ff0000");
    private static final Color blue = ColorUtils.stringToColor((String)"#0099ff");
    private static final Color green = ColorUtils.stringToColor((String)"#009900");
    private static final Color purple = ColorUtils.stringToColor((String)"#cc00cc");
    private static final Color orange = ColorUtils.stringToColor((String)"#ff6600");
    private static Color[] colors = new Color[]{original, red, blue, green, purple, orange};
    private int currentColorIndex = 0;

    public IconColorReplacer(List<Image> iconImages) {
        this.originalIconImages = iconImages;
        this.derivedImages = new HashMap<Color, List<Image>>();
        this.derivedImages.put(original, iconImages);
    }

    public List<Image> getNextIconImages() {
        ++this.currentColorIndex;
        this.currentColorIndex %= colors.length;
        Color requiredColor = colors[this.currentColorIndex];
        List<Image> coloredImages = this.derivedImages.get(requiredColor);
        if (coloredImages != null) {
            return coloredImages;
        }
        coloredImages = new ArrayList<Image>(this.originalIconImages.size());
        for (Image originalImage : this.originalIconImages) {
            ColoredIconCreator coloredIconCreator = new ColoredIconCreator(originalImage, original);
            Image coloredImage = coloredIconCreator.createColoredImage(requiredColor);
            coloredImages.add(coloredImage);
        }
        this.derivedImages.put(requiredColor, coloredImages);
        return coloredImages;
    }
}

