/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bsfv;

import docking.Tool;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphLabelPosition;
import ghidra.service.graph.GraphType;
import ghidra.service.graph.VertexShape;
import ghidra.util.HelpLocation;

public class BSimFeatureGraphDisplayOptions
extends GraphDisplayOptions {
    public BSimFeatureGraphDisplayOptions(GraphType graphType, Tool tool) {
        super(graphType, tool, new HelpLocation("BSimFeatureVisualizerPlugin", "Visualizing_BSim_Features"));
    }

    protected void initializeDefaults() {
        this.setDefaultVertexColor("color.bsim.graph.vertex.default");
        this.setDefaultEdgeColor("color.bsim.graph.edge.default");
        this.setVertexSelectionColor("color.bsim.graph.vertex.selection");
        this.setEdgeSelectionColor("color.bsim.graph.edge.selection");
        this.setDefaultVertexShape(VertexShape.ELLIPSE);
        this.setDefaultLayoutAlgorithmName("Hierarchical MinCross Top Down");
        this.setUsesIcons(false);
        this.setLabelPosition(GraphLabelPosition.EAST);
        this.configureVertexType("Pcode Op", VertexShape.ELLIPSE, "color.bsim.graph.dataflow.vertex.pcode.op");
        this.configureVertexType("Base Varnode", VertexShape.ELLIPSE, "color.bsim.graph.dataflow.vertex.base");
        this.configureVertexType("Secondary Base Varnode", VertexShape.ELLIPSE, "color.bsim.graph.dataflow.vertex.base.2");
        this.configureVertexType("Collapsed Op", VertexShape.ELLIPSE, "color.bsim.graph.dataflow.vertex.pcode.op.collapsed");
        this.configureVertexType("Collapsed Varnode", VertexShape.ELLIPSE, "color.bsim.graph.dataflow.vertex.varnode.collapsed");
        this.configureVertexType("Base Block", VertexShape.RECTANGLE, "color.bsim.graph.controlflow.vertex.base");
        this.configureVertexType("Parent Block", VertexShape.RECTANGLE, "color.bsim.graph.controlflow.vertex.parent");
        this.configureVertexType("Grandparent Block", VertexShape.RECTANGLE, "color.bsim.graph.controlflow.vertex.grandparent");
        this.configureVertexType("Sibling Block", VertexShape.RECTANGLE, "color.bsim.graph.controlflow.vertex.sibling");
        this.configureVertexType("Child Block", VertexShape.RECTANGLE, "color.bsim.graph.controlflow.vertex.child");
        this.configureVertexType("BSim Neighbor Block", VertexShape.RECTANGLE, "color.bsim.graph.controlflow.vertex.neighbor");
        this.configureEdgeType("True", "color.bsim.graph.edge.controlflow.true");
        this.configureEdgeType("False", "color.bsim.graph.edge.controlflow.false");
        this.configureEdgeType("Collapsed Input", "color.bsim.graph.edge.dataflow.in.collapsed");
        this.configureEdgeType("Collapsed Output", "color.bsim.graph.edge.dataflow.out.collapsed");
        this.configureEdgeType("Input", "color.bsim.graph.edge.dataflow.in");
        this.configureEdgeType("Output", "color.bsim.graph.edge.dataflow.out");
    }
}

