/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ExternalSymbolResolver;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class ExternalSymbolResolverAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "External Symbol Resolver";
    private static final String DESCRIPTION = "Links unresolved external symbols to the first symbol found in the program's required libraries list (found in program properties).";

    public ExternalSymbolResolverAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.before().before().before().before());
    }

    @Override
    public boolean canAnalyze(Program program) {
        if (program.getDomainFile().getParent() == null) {
            return false;
        }
        String format = program.getExecutableFormat();
        return "Executable and Linking Format (ELF)".equals(format) || "Mac OS X Mach-O".equals(format);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try (ExternalSymbolResolver esr = new ExternalSymbolResolver(program.getDomainFile().getParent().getProjectData(), monitor);){
            esr.addProgramToFixup(program);
            esr.fixUnresolvedExternalSymbols();
            esr.logInfo(s -> Msg.info((Object)this, (Object)s), false);
            if (esr.hasProblemLibraries()) {
                esr.logInfo(arg_0 -> ((MessageLog)log).appendMsg(arg_0), true);
            }
            boolean bl = true;
            return bl;
        }
    }
}

