/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.actions.KeyBindingUtils;
import javax.swing.KeyStroke;

class KeyBindingsInfo
implements Comparable<KeyBindingsInfo> {
    boolean hasAction;
    String keystroke;
    String errorMessage;

    KeyBindingsInfo(boolean isActionBinding, KeyStroke keyBinding, String errorMessage) {
        this(isActionBinding, keyBinding);
        this.errorMessage = errorMessage;
    }

    KeyBindingsInfo(boolean hasAction, KeyStroke stroke) {
        this.hasAction = hasAction;
        this.keystroke = stroke == null ? "" : KeyBindingUtils.parseKeyStroke((KeyStroke)stroke);
    }

    public String toString() {
        if (this.errorMessage != null) {
            return "error";
        }
        return this.keystroke;
    }

    @Override
    public int compareTo(KeyBindingsInfo o) {
        return this.keystroke.compareToIgnoreCase(o.keystroke);
    }
}

