/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.expression;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.format.dwarf.DIEAggregate;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionEvaluator;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOpCodes;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOperandType;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOperation;
import ghidra.program.model.data.LEB128;
import ghidra.util.NumericUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DWARFExpression {
    static long[] EMPTY_OPERANDS_VALUE = new long[0];
    public static final int MAX_SANE_EXPR = 256;
    private final List<DWARFExpressionOperation> operations;
    private final int lastActiveOpIndex;

    public static String exprToString(byte[] exprBytes, DIEAggregate diea) {
        try {
            DWARFExpression expr = new DWARFExpressionEvaluator(diea.getCompilationUnit()).readExpr(exprBytes);
            return expr.toString();
        }
        catch (DWARFExpressionException e) {
            return "Unable to parse DWARF expression.  Raw bytes: " + NumericUtilities.convertBytesToString((byte[])exprBytes, (String)" ");
        }
    }

    public static DWARFExpression read(byte[] exprBytes, byte addrSize, boolean isLittleEndian, int intSize) throws DWARFExpressionException {
        ByteArrayProvider provider = new ByteArrayProvider(exprBytes);
        BinaryReader reader = new BinaryReader(provider, isLittleEndian);
        return DWARFExpression.read(reader, addrSize, intSize);
    }

    public static DWARFExpression read(BinaryReader reader, byte addrSize, int intSize) throws DWARFExpressionException {
        ArrayList<DWARFExpressionOperation> operations = new ArrayList<DWARFExpressionOperation>();
        try {
            long opcodeoffset;
            boolean invalidOpCodeEncountered = false;
            while ((opcodeoffset = reader.getPointerIndex()) < reader.length()) {
                int opcode = reader.readNextUnsignedByte();
                if (!DWARFExpressionOpCodes.isValidOpcode(opcode)) {
                    int bytesLeft = (int)(reader.length() - reader.getPointerIndex());
                    operations.add(new DWARFExpressionOperation(opcode, DWARFExpressionOpCodes.BLOBONLY_OPERANDTYPES, new long[]{0L}, DWARFExpression.readSizedBlobOperand(reader, bytesLeft), (int)opcodeoffset));
                    invalidOpCodeEncountered = true;
                    continue;
                }
                DWARFExpressionOperandType[] operandTypes = DWARFExpressionOpCodes.getOperandTypesFor(opcode);
                long[] operandValues = operandTypes.length != 0 ? new long[operandTypes.length] : EMPTY_OPERANDS_VALUE;
                byte[] blob = null;
                for (int i = 0; i < operandTypes.length; ++i) {
                    DWARFExpressionOperandType optype = operandTypes[i];
                    if (optype == DWARFExpressionOperandType.SIZED_BLOB) {
                        blob = DWARFExpression.readSizedBlobOperand(reader, operandValues[i - 1]);
                        continue;
                    }
                    operandValues[i] = DWARFExpression.readOperandValue(optype, reader, addrSize, intSize);
                }
                DWARFExpressionOperation op = new DWARFExpressionOperation(opcode, operandTypes, operandValues, blob, (int)opcodeoffset);
                operations.add(op);
            }
            if (invalidOpCodeEncountered) {
                throw new IOException("Unknown DWARF opcode(s) encountered");
            }
            return new DWARFExpression(operations);
        }
        catch (IOException ioe) {
            DWARFExpression badExpr = new DWARFExpression(operations);
            String s = badExpr.toString();
            throw new DWARFExpressionException("Error reading DWARF expression, partial expression is: ", badExpr, -1, ioe);
        }
    }

    private static long readOperandValue(DWARFExpressionOperandType operandType, BinaryReader reader, byte addrSize, int intSize) throws IOException {
        try {
            switch (operandType) {
                case ADDR: {
                    return reader.readNextUnsignedValue(addrSize);
                }
                case S_BYTE: {
                    return reader.readNextByte();
                }
                case S_SHORT: {
                    return reader.readNextShort();
                }
                case S_INT: {
                    return reader.readNextInt();
                }
                case S_LONG: {
                    return reader.readNextLong();
                }
                case U_BYTE: {
                    return reader.readNextUnsignedByte();
                }
                case U_SHORT: {
                    return reader.readNextUnsignedShort();
                }
                case U_INT: {
                    return reader.readNextUnsignedInt();
                }
                case U_LONG: {
                    return reader.readNextLong();
                }
                case S_LEB128: {
                    return reader.readNext(LEB128::signed);
                }
                case U_LEB128: {
                    return reader.readNext(LEB128::unsigned);
                }
                case SIZED_BLOB: {
                    throw new IOException("Can't read SIZED_BLOB as a Long value");
                }
                case DWARF_INT: {
                    return reader.readNextUnsignedValue(intSize);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            throw new IOException("Not enough bytes to read " + String.valueOf((Object)operandType));
        }
        throw new IOException("Unknown DWARFExpressionOperandType " + String.valueOf((Object)operandType));
    }

    private static byte[] readSizedBlobOperand(BinaryReader reader, long previousOperandValue) throws IOException {
        return reader.readNextByteArray((int)previousOperandValue);
    }

    private DWARFExpression(List<DWARFExpressionOperation> operations) {
        this.operations = operations;
        this.lastActiveOpIndex = this.findLastActiveOpIndex();
    }

    public DWARFExpressionOperation getOp(int i) {
        return this.operations.get(i);
    }

    public int getOpCount() {
        return this.operations.size();
    }

    public int getLastActiveOpIndex() {
        return this.lastActiveOpIndex;
    }

    private int findLastActiveOpIndex() {
        for (int i = this.operations.size() - 1; i >= 0; --i) {
            if (this.operations.get(i).getOpCode() == 150) continue;
            return i;
        }
        return this.operations.size() - 1;
    }

    public int findOpByOffset(long offset) {
        for (int i = 0; i < this.operations.size(); ++i) {
            DWARFExpressionOperation op = this.getOp(i);
            if ((long)op.getOffset() != offset) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.toString(-1, false, false);
    }

    public String toString(int caretPosition, boolean newlines, boolean offsets) {
        StringBuilder sb = new StringBuilder();
        for (int step = 0; step < this.operations.size(); ++step) {
            int opcode;
            DWARFExpressionOperation op = this.operations.get(step);
            if (step != 0) {
                sb.append("; ");
                if (newlines) {
                    sb.append('\n');
                }
            }
            if (offsets) {
                sb.append(String.format("%3d [%03x]: ", step, op.getOffset()));
            }
            if (caretPosition == step) {
                sb.append(" ==> [");
            }
            if (DWARFExpressionOpCodes.isValidOpcode(opcode = op.getOpCode())) {
                sb.append(DWARFExpressionOpCodes.toString(opcode));
            } else if (opcode >= 224 && opcode <= 255) {
                int relOpCode = opcode - 224;
                sb.append(DWARFExpressionOpCodes.toString(224) + "+" + relOpCode + "[" + opcode + "]");
            } else {
                sb.append("DW_OP_UNKNOWN[" + opcode + "]");
            }
            for (int operandIndex = 0; operandIndex < op.operands.length; ++operandIndex) {
                if (operandIndex == 0) {
                    sb.append(':');
                }
                sb.append(' ');
                DWARFExpressionOperandType operandType = op.operandTypes[operandIndex];
                if (operandType != DWARFExpressionOperandType.SIZED_BLOB) {
                    long operandValue = op.operands[operandIndex];
                    sb.append(DWARFExpressionOperandType.valueToString(operandValue, operandType));
                    continue;
                }
                sb.append(NumericUtilities.convertBytesToString((byte[])op.blob, (String)" "));
            }
            if (caretPosition == step) {
                sb.append(" ] <==");
            }
            if (opcode != 40 && opcode != 47) continue;
            long destOffset = op.getOperandValue(0) + (long)op.getOffset();
            int destIndex = this.findOpByOffset(destOffset);
            sb.append(String.format(" /* dest index: %d, offset: %03x */", destIndex, (int)destOffset));
        }
        return sb.toString();
    }
}

