/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.Loaded;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class LoadResults<T extends DomainObject>
implements Iterable<Loaded<T>> {
    private final List<Loaded<T>> loadedList;

    public LoadResults(List<Loaded<T>> loadedList) throws IllegalArgumentException {
        if (loadedList == null || loadedList.isEmpty()) {
            throw new IllegalArgumentException("The loaded list must not be empty");
        }
        this.loadedList = new ArrayList<Loaded<T>>(loadedList);
    }

    public LoadResults(T domainObject, String name, String projectFolderPath) {
        this(List.of(new Loaded<T>(domainObject, name, projectFolderPath)));
    }

    public Loaded<T> getPrimary() {
        return this.loadedList.get(0);
    }

    public T getPrimaryDomainObject() {
        return this.loadedList.get(0).getDomainObject();
    }

    public int size() {
        return this.loadedList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Project project, Object consumer, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        boolean success = false;
        try {
            for (Loaded<T> loaded : this.loadedList) {
                loaded.save(project, messageLog, monitor);
            }
            success = true;
        }
        finally {
            if (!success) {
                for (Loaded<T> loaded : this) {
                    try {
                        loaded.release(consumer);
                        loaded.deleteSavedDomainFile(consumer);
                    }
                    catch (IOException e1) {
                        Msg.error(this.getClass(), (Object)("Failed to delete: " + String.valueOf(loaded)));
                    }
                }
            }
        }
    }

    public void release(Object consumer) {
        this.loadedList.forEach(loaded -> loaded.release(consumer));
    }

    public void release(Object consumer, Predicate<? super Loaded<T>> filter) {
        this.loadedList.stream().filter(filter).forEach(loaded -> loaded.release(consumer));
    }

    public void releaseNonPrimary(Object consumer) {
        for (int i = 0; i < this.loadedList.size(); ++i) {
            if (i <= 0) continue;
            this.loadedList.get(i).release(consumer);
        }
    }

    @Override
    public Iterator<Loaded<T>> iterator() {
        return this.loadedList.iterator();
    }
}

