/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.format;

import ghidra.features.base.memsearch.format.BinarySearchFormat;
import ghidra.features.base.memsearch.format.DecimalSearchFormat;
import ghidra.features.base.memsearch.format.FloatSearchFormat;
import ghidra.features.base.memsearch.format.HexSearchFormat;
import ghidra.features.base.memsearch.format.RegExSearchFormat;
import ghidra.features.base.memsearch.format.StringSearchFormat;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;

public abstract class SearchFormat {
    public static SearchFormat HEX = new HexSearchFormat();
    public static SearchFormat BINARY = new BinarySearchFormat();
    public static SearchFormat DECIMAL = new DecimalSearchFormat();
    public static SearchFormat STRING = new StringSearchFormat();
    public static SearchFormat REG_EX = new RegExSearchFormat();
    public static SearchFormat FLOAT = new FloatSearchFormat("Float", "Floating Point", 4);
    public static SearchFormat DOUBLE = new FloatSearchFormat("Double", "Floating Point (8)", 8);
    public static SearchFormat[] ALL = new SearchFormat[]{HEX, BINARY, DECIMAL, STRING, REG_EX, FLOAT, DOUBLE};
    private final String name;

    protected SearchFormat(String name) {
        this.name = name;
    }

    public abstract ByteMatcher parse(String var1, SearchSettings var2);

    public abstract String getToolTip();

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public String getValueString(byte[] bytes, SearchSettings settings) {
        return "";
    }

    public abstract String convertText(String var1, SearchSettings var2, SearchSettings var3);

    public abstract SearchFormatType getFormatType();

    public int compareValues(byte[] bytes1, byte[] bytes2, SearchSettings settings) {
        return this.compareBytesUnsigned(bytes1, bytes2);
    }

    protected void reverse(byte[] bytes) {
        for (int i = 0; i < bytes.length / 2; ++i) {
            int swapIndex = bytes.length - 1 - i;
            byte tmp = bytes[i];
            bytes[i] = bytes[swapIndex];
            bytes[swapIndex] = tmp;
        }
    }

    private int compareBytesUnsigned(byte[] oldBytes, byte[] newBytes) {
        for (int i = 0; i < oldBytes.length; ++i) {
            int value1 = oldBytes[i] & 0xFF;
            int value2 = newBytes[i] & 0xFF;
            if (value1 == value2) continue;
            return value1 - value2;
        }
        return 0;
    }

    protected boolean isValidText(String text, SearchSettings settings) {
        ByteMatcher byteMatcher = this.parse(text, settings);
        return byteMatcher.isValidSearch();
    }

    public static enum SearchFormatType {
        BYTE,
        INTEGER,
        FLOATING_POINT,
        STRING_TYPE;

    }
}

