/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.DialogActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.support.GTreeSelectionListener;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.main.DialogProjectDataCollapseAction;
import ghidra.framework.main.DialogProjectDataExpandAction;
import ghidra.framework.main.DialogProjectDataNewFolderAction;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DialogProjectTreeContext;
import ghidra.framework.main.datatree.ProjectDataTreePanel;
import ghidra.framework.main.projectdata.actions.ProjectDataCollapseAction;
import ghidra.framework.main.projectdata.actions.ProjectDataExpandAction;
import ghidra.framework.main.projectdata.actions.ProjectDataNewFolderAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractDataTreeDialog
extends DialogComponentProvider
implements GTreeSelectionListener,
ActionListener {
    protected static final int WIDTH = 350;
    protected static final int HEIGHT = 500;
    protected ProjectDataTreePanel treePanel;
    private JComboBox<String> projectComboBox;
    private ProjectLocator[] projectLocators;
    private DomainFileFilter filter;
    private JTextField nameField;
    private JLabel folderNameLabel;
    private ActionListener okActionListener;
    private DomainFolder domainFolder;
    private DomainFile domainFile;
    private DataTreeDialogType type;
    private Component parent;
    private boolean cancelled = false;
    private ProjectDataExpandAction<DialogProjectTreeContext> expandAction;
    private ProjectDataCollapseAction<DialogProjectTreeContext> collapseAction;
    private ProjectDataNewFolderAction<DialogProjectTreeContext> newFolderAction;
    private Integer treeSelectionMode;
    private final Project project;

    protected AbstractDataTreeDialog(Component parent, String title, DataTreeDialogType type, DomainFileFilter filter, Project project) {
        super(title, true, true, true, false);
        this.project = project;
        this.parent = parent;
        this.type = type;
        this.filter = filter;
        this.initializeButtons();
        this.rootPanel.setPreferredSize(new Dimension(350, 500));
        this.createActions();
    }

    protected void initializeFocusedComponent() {
        Component focusComponent = this.nameField;
        if (!this.nameField.isEditable()) {
            focusComponent = this.treePanel.getFilterField();
        }
        this.setFocusComponent(focusComponent);
    }

    public void setTreeSelectionMode(int mode) {
        if (this.treePanel != null) {
            this.treePanel.getTreeSelectionModel().setSelectionMode(mode);
        }
        this.treeSelectionMode = mode;
    }

    private void initializeButtons() {
        this.addOKButton();
        this.addCancelButton();
        if (this.type == DataTreeDialogType.SAVE) {
            this.okButton.setText("Save");
            this.okButton.setMnemonic('S');
        } else if (this.type == DataTreeDialogType.CREATE) {
            this.okButton.setText("Create");
            this.okButton.setMnemonic('C');
        }
        this.setOkEnabled(false);
    }

    private void createActions() {
        String owner = "DataTreeDialogActions";
        String groupName = "Cut/copy/paste/new";
        this.newFolderAction = new DialogProjectDataNewFolderAction(owner, groupName);
        groupName = "Expand/Collapse";
        this.expandAction = new DialogProjectDataExpandAction(owner, groupName);
        this.collapseAction = new DialogProjectDataCollapseAction(owner, groupName);
        this.addAction((DockingActionIf)this.newFolderAction);
        this.addAction((DockingActionIf)this.expandAction);
        this.addAction((DockingActionIf)this.collapseAction);
    }

    public void addOkActionListener(ActionListener l) {
        this.okActionListener = l;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.treePanel == null) {
            return super.getActionContext(event);
        }
        ActionContext actionContext = this.treePanel.getActionContext(null, event);
        if (actionContext instanceof DialogActionContext) {
            DialogActionContext dac = (DialogActionContext)actionContext;
            dac.setDialogComponentProvider((DialogComponentProvider)this);
        }
        return actionContext;
    }

    public void show() {
        DockingWindowManager.showDialog((Component)this.parent, (DialogComponentProvider)this);
    }

    public void showComponent() {
        this.show();
    }

    public GTree getTree() {
        return this.treePanel.getDataTree();
    }

    public String getNameText() {
        return this.nameField.getText();
    }

    public void setNameText(String name) {
        DataTree tree = this.treePanel.getDataTree();
        tree.runTask((GTreeTask)new SetNameTextTask((GTree)tree, name));
    }

    public void setSelectedFolder(DomainFolder folder) {
        if (folder != null) {
            this.treePanel.selectDomainFolder(folder);
        }
    }

    public DomainFile getDomainFile() {
        if (this.domainFile != null) {
            return this.domainFile;
        }
        if (this.cancelled) {
            return null;
        }
        if (this.treePanel != null) {
            this.domainFile = this.treePanel.getSelectedDomainFile();
        }
        return this.domainFile;
    }

    public DomainFolder getDomainFolder() {
        if (this.cancelled) {
            return null;
        }
        if (this.domainFolder == null) {
            this.domainFolder = this.treePanel.getSelectedDomainFolder();
        }
        return this.domainFolder;
    }

    public void valueChanged(GTreeSelectionEvent e) {
        this.clearStatusText();
        if (this.type == DataTreeDialogType.CHOOSE_FOLDER) {
            this.domainFolder = this.treePanel.getSelectedDomainFolder();
            if (this.domainFolder != null) {
                DomainFolder folderParent = this.domainFolder.getParent();
                if (folderParent != null) {
                    this.folderNameLabel.setText(folderParent.getPathname());
                } else {
                    this.folderNameLabel.setText("    ");
                }
                this.nameField.setText(this.domainFolder.getName());
            } else {
                this.domainFile = this.treePanel.getSelectedDomainFile();
                if (this.domainFile != null) {
                    this.domainFolder = this.domainFile.getParent();
                    DomainFolder grandParent = this.domainFolder.getParent();
                    if (grandParent != null) {
                        this.folderNameLabel.setText(grandParent.getPathname());
                    } else {
                        this.folderNameLabel.setText("");
                    }
                    this.nameField.setText(this.domainFolder.getName());
                } else {
                    this.domainFolder = this.project.getProjectData().getRootFolder();
                    this.folderNameLabel.setText(this.domainFolder.getPathname());
                    this.nameField.setText(this.domainFolder.getName());
                }
            }
        } else {
            this.domainFile = this.treePanel.getSelectedDomainFile();
            if (this.domainFile != null) {
                this.folderNameLabel.setText(this.domainFile.getParent().getPathname());
                this.nameField.setText(this.domainFile.getName());
                this.domainFolder = this.domainFile.getParent();
            } else {
                this.domainFolder = this.treePanel.getSelectedDomainFolder();
                if (this.domainFolder == null) {
                    this.domainFolder = this.project.getProjectData().getRootFolder();
                }
                this.folderNameLabel.setText(this.domainFolder.getPathname());
                if (this.nameField.isEditable()) {
                    if (this.nameField.getText().length() > 0) {
                        this.nameField.selectAll();
                    }
                } else {
                    this.nameField.setText("");
                }
            }
        }
        String text = this.nameField.getText();
        this.setOkEnabled(text != null && !text.isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int index = this.projectComboBox.getSelectedIndex();
        if (index < 0) {
            return;
        }
        ProjectLocator projectLocator = this.projectLocators[index];
        ProjectData pd = this.project.getProjectData(projectLocator);
        String projectName = projectLocator.getName();
        if (pd == null) {
            Msg.showError((Object)this, (Component)this.getComponent(), (String)"Error Getting Project Data", (Object)("Could not get project data for " + projectName));
        } else {
            this.treePanel.setProjectData(projectName, pd);
        }
    }

    public void selectFolder(DomainFolder folder) {
        Swing.runLater(() -> this.treePanel.selectDomainFolder(folder));
    }

    public void selectDomainFile(DomainFile file) {
        Swing.runLater(() -> this.treePanel.selectDomainFile(file));
    }

    public void close() {
        super.close();
        this.removeWorkPanel();
        if (this.treePanel != null) {
            this.treePanel.dispose();
        }
        this.treePanel = null;
    }

    protected JPanel buildDataTreePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel namePanel = this.createNamePanel();
        JPanel dataTreePanel = this.createDataTreePanel();
        this.treePanel.selectRootDataFolder();
        if (this.type == DataTreeDialogType.OPEN) {
            JPanel comboPanel = this.createComboBoxPanel();
            panel.add((Component)comboPanel, "North");
            this.populateProjectModel();
        }
        panel.add((Component)dataTreePanel, "Center");
        panel.add((Component)namePanel, "South");
        this.addTreeListeners();
        return panel;
    }

    protected void okCallback() {
        this.cancelled = false;
        if (this.okActionListener == null) {
            this.close();
            return;
        }
        this.okActionListener.actionPerformed(new ActionEvent(this.okButton, 0, this.okButton.getActionCommand()));
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    protected void cancelCallback() {
        this.cancelled = true;
        this.close();
    }

    private JPanel createDataTreePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        ProjectData pd = this.project.getProjectData();
        this.treePanel = new ProjectDataTreePanel(this.project.getName(), true, null, this.filter);
        if (this.treeSelectionMode != null) {
            this.treePanel.getTreeSelectionModel().setSelectionMode(this.treeSelectionMode);
        }
        this.treePanel.setProjectData(this.project.getName(), pd);
        this.treePanel.addTreeSelectionListener((GTreeSelectionListener)this);
        this.treePanel.setPreferredTreePanelSize(new Dimension(150, 150));
        boolean userChoosesName = this.type == DataTreeDialogType.SAVE || this.type == DataTreeDialogType.CREATE;
        this.treePanel.setTreeFilterEnabled(!userChoosesName);
        panel.add((Component)this.treePanel, "Center");
        return panel;
    }

    protected void addTreeListeners() {
        if (this.type == DataTreeDialogType.OPEN) {
            this.treePanel.addTreeMouseListener((MouseListener)new GMouseListenerAdapter(){

                public void doubleClickTriggered(MouseEvent e) {
                    if (AbstractDataTreeDialog.this.okButton.isEnabled()) {
                        AbstractDataTreeDialog.this.okCallback();
                    }
                }
            });
        }
    }

    private JPanel createComboBoxPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder("Current Projects"));
        this.projectComboBox = new GComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        this.projectComboBox.setModel(model);
        model.addElement("defaultProject");
        panel.add(this.projectComboBox, "Center");
        this.projectComboBox.addActionListener(this);
        return panel;
    }

    private JPanel createNamePanel() {
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BorderLayout(5, 0));
        this.nameField = new JTextField(12);
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                String text = AbstractDataTreeDialog.this.nameField.getText();
                switch (AbstractDataTreeDialog.this.type) {
                    case OPEN: {
                        break;
                    }
                    case SAVE: {
                        if (text != null && !text.isEmpty()) break;
                        DomainFile file = AbstractDataTreeDialog.this.treePanel.getSelectedDomainFile();
                        AbstractDataTreeDialog.this.okButton.setEnabled(file != null);
                        break;
                    }
                    case CREATE: {
                        if (text != null && !text.isEmpty()) break;
                        DomainFile file = AbstractDataTreeDialog.this.treePanel.getSelectedDomainFile();
                        AbstractDataTreeDialog.this.okButton.setEnabled(file != null);
                        break;
                    }
                    case CHOOSE_FOLDER: {
                        break;
                    }
                    default: {
                        throw new AssertException("Must handle new type!: " + String.valueOf((Object)AbstractDataTreeDialog.this.type));
                    }
                }
                AbstractDataTreeDialog.this.setOkEnabled(text != null && !text.isEmpty());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
        boolean userChoosesName = this.type == DataTreeDialogType.SAVE || this.type == DataTreeDialogType.CREATE;
        this.nameField.setEditable(userChoosesName);
        this.nameField.setEnabled(userChoosesName);
        JPanel namePanel = new JPanel((LayoutManager)new PairLayout(2, 5, 100));
        if (!userChoosesName) {
            namePanel.setBorder(BorderFactory.createEmptyBorder(20, 5, 5, 5));
        }
        namePanel.add((Component)new GLabel("Folder Path:", 4));
        this.folderNameLabel = new GDLabel("   ");
        namePanel.add(this.folderNameLabel);
        namePanel.add((Component)new GLabel(this.type == DataTreeDialogType.CHOOSE_FOLDER ? "Folder Name:" : "Name:", 4));
        namePanel.add(this.nameField);
        outerPanel.add((Component)namePanel, "Center");
        FieldKeyListener l = new FieldKeyListener();
        this.nameField.addKeyListener(l);
        this.nameField.addActionListener(e -> this.okCallback());
        return outerPanel;
    }

    private void populateProjectModel() {
        ProjectLocator[] views = this.project.getProjectViews();
        this.projectLocators = new ProjectLocator[views.length + 1];
        this.projectLocators[0] = this.project.getProjectLocator();
        for (int i = 0; i < views.length; ++i) {
            this.projectLocators[i + 1] = views[i];
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.projectComboBox.getModel();
        model.removeAllElements();
        HashSet<String> map = new HashSet<String>();
        for (ProjectLocator projectLocator : this.projectLocators) {
            String name = projectLocator.getName();
            if (map.contains(name)) {
                model.addElement(name + " (" + projectLocator.getLocation() + ")");
                continue;
            }
            map.add(name);
            model.addElement(name);
        }
        map = null;
    }

    public void setSearchText(String s) {
        if (s != null) {
            this.treePanel.findAndSelect(s);
        }
    }

    protected static DomainFileFilter getDefaultFilter(DataTreeDialogType type) {
        if (type == DataTreeDialogType.CHOOSE_FOLDER || type == DataTreeDialogType.OPEN) {
            return new DomainFileFilter(){

                public boolean accept(DomainFile df) {
                    return true;
                }
            };
        }
        return null;
    }

    private class SetNameTextTask
    extends GTreeTask {
        private String text;

        SetNameTextTask(GTree gTree, String text) {
            super(gTree);
            this.text = text;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            this.runOnSwingThread(() -> {
                AbstractDataTreeDialog.this.nameField.setText(this.text.trim());
                AbstractDataTreeDialog.this.nameField.selectAll();
            });
        }
    }

    private class FieldKeyListener
    extends KeyAdapter {
        private FieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            AbstractDataTreeDialog.this.clearStatusText();
        }
    }
}

