/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.services.FileImporterService;
import ghidra.app.util.FileOpenDataFlavorHandler;
import ghidra.framework.main.datatree.DataTreeFlavorHandler;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.Component;
import java.io.File;
import java.util.List;

abstract class AbstractFileListFlavorHandler
implements DataTreeFlavorHandler,
FileOpenDataFlavorHandler {
    AbstractFileListFlavorHandler() {
    }

    protected void doImport(DomainFolder folder, List<File> files, PluginTool tool, Component component) {
        Swing.runLater(() -> {
            FileImporterService im = (FileImporterService)tool.getService(FileImporterService.class);
            if (im == null) {
                Msg.showError(AbstractFileListFlavorHandler.class, (Component)component, (String)"Could Not Import", (Object)"Could not find importer service.");
                return;
            }
            if (files.size() == 1 && ((File)files.get(0)).isFile()) {
                im.importFile(folder, (File)files.get(0));
            } else {
                im.importFiles(folder, files);
            }
        });
    }

    protected DomainFolder getDomainFolder(GTreeNode destinationNode) {
        if (destinationNode instanceof DomainFolderNode) {
            return ((DomainFolderNode)destinationNode).getDomainFolder();
        }
        if (destinationNode instanceof DomainFileNode) {
            DomainFolderNode parent = (DomainFolderNode)destinationNode.getParent();
            return parent.getDomainFolder();
        }
        return null;
    }
}

