/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.object;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.naming.MDFragmentName;
import mdemangler.object.MDObject;

public class MDObjectC
extends MDObject {
    protected MDFragmentName name;
    int conventionIndex = -1;
    int numParameterBytes = 0;
    private final String[] callingConvention = new String[]{"__cdecl", "__stdcall", "__fastcall", "__vectorcall"};

    public MDObjectC(MDMang dmang) {
        super(dmang);
        this.name = new MDFragmentName(dmang);
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getName();
    }

    public String getCallingConvention() {
        if (this.conventionIndex == -1) {
            return null;
        }
        return this.callingConvention[this.conventionIndex];
    }

    public int getNumParameterBytes() {
        return this.numParameterBytes;
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.conventionIndex >= 1 && this.conventionIndex <= 3) {
            builder.append(this.callingConvention[this.conventionIndex]);
            builder.append(' ');
        }
        builder.append(this.name);
        if (this.conventionIndex >= 1 && this.conventionIndex <= 3) {
            builder.append(',');
            builder.append(this.numParameterBytes);
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        if (!this.dmang.isFunction()) {
            this.name.parse();
            return;
        }
        int index = this.dmang.getIndex();
        char c = this.dmang.peek();
        if (c == '@') {
            this.conventionIndex = 2;
            this.dmang.next();
        } else if (c == '_') {
            this.conventionIndex = 0;
            this.dmang.next();
        } else {
            this.conventionIndex = 3;
        }
        this.name.parse();
        c = this.dmang.peek();
        if (c == '@') {
            if (this.conventionIndex != 3) {
                throw new MDException("Error parsing C Object calling convention");
            }
            this.dmang.next();
        } else if (this.conventionIndex == 0 && this.dmang.getMangledSymbol().charAt(this.dmang.getIndex() - 1) == '@') {
            this.conventionIndex = 1;
        }
        if (this.dmang.getArchitectureSize() != 32 && this.conventionIndex != 3) {
            this.conventionIndex = -1;
            this.dmang.setIndex(index);
            this.name.parse();
            return;
        }
        if (this.conventionIndex != 0) {
            this.numParameterBytes = this.parseNumParameterBytes();
        }
    }

    private int parseNumParameterBytes() throws MDException {
        int loc = this.dmang.getIndex();
        String str = this.dmang.getMangledSymbol().substring(loc);
        this.dmang.setIndex(loc + this.dmang.getNumCharsRemaining());
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new MDException("Error parsing C Object calling convention");
        }
    }
}

