/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.microsoft;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledFunctionIndirect;
import ghidra.app.util.demangler.DemangledFunctionPointer;
import ghidra.app.util.demangler.DemangledFunctionReference;
import ghidra.app.util.demangler.DemangledNamespaceNode;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledParameter;
import ghidra.app.util.demangler.DemangledString;
import ghidra.app.util.demangler.DemangledType;
import ghidra.app.util.demangler.DemangledUnknown;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.program.model.symbol.SourceType;
import java.util.Iterator;
import mdemangler.MDMangUtils;
import mdemangler.MDParsableItem;
import mdemangler.MDString;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDVarArgsType;
import mdemangler.datatype.complex.MDClassType;
import mdemangler.datatype.complex.MDCoclassType;
import mdemangler.datatype.complex.MDCointerfaceType;
import mdemangler.datatype.complex.MDComplexType;
import mdemangler.datatype.complex.MDEnumType;
import mdemangler.datatype.complex.MDStructType;
import mdemangler.datatype.complex.MDUnionType;
import mdemangler.datatype.extended.MDArrayReferencedType;
import mdemangler.datatype.modifier.MDArrayBasicType;
import mdemangler.datatype.modifier.MDCVMod;
import mdemangler.datatype.modifier.MDDataReferenceType;
import mdemangler.datatype.modifier.MDDataRightReferenceType;
import mdemangler.datatype.modifier.MDFunctionIndirectType;
import mdemangler.datatype.modifier.MDModifierType;
import mdemangler.datatype.modifier.MDPointerRefDataType;
import mdemangler.datatype.modifier.MDPointerType;
import mdemangler.datatype.modifier.MDReferenceType;
import mdemangler.datatype.modifier.MDStdNullPtrType;
import mdemangler.functiontype.MDArgumentsList;
import mdemangler.functiontype.MDFunctionType;
import mdemangler.functiontype.MDThrowAttribute;
import mdemangler.naming.MDQualification;
import mdemangler.naming.MDQualifiedName;
import mdemangler.naming.MDQualifier;
import mdemangler.object.MDObjectBracket;
import mdemangler.object.MDObjectC;
import mdemangler.object.MDObjectCPP;
import mdemangler.object.MDObjectCodeView;
import mdemangler.object.MDObjectReserved;
import mdemangler.template.MDTemplateNameAndArguments;
import mdemangler.typeinfo.AbstractMDMetaClass;
import mdemangler.typeinfo.MDFunctionInfo;
import mdemangler.typeinfo.MDGuard;
import mdemangler.typeinfo.MDMemberFunctionInfo;
import mdemangler.typeinfo.MDTypeInfo;
import mdemangler.typeinfo.MDVCall;
import mdemangler.typeinfo.MDVFAdjustor;
import mdemangler.typeinfo.MDVariableInfo;
import mdemangler.typeinfo.MDVtordisp;
import mdemangler.typeinfo.MDVtordispex;
import mdemangler.typeinfo.MDVxTable;

public class MicrosoftDemanglerUtil {
    private MicrosoftDemanglerUtil() {
    }

    static DemangledObject convertToDemangledObject(MDParsableItem item, String mangled, String originalDemangled) throws DemangledException {
        return MicrosoftDemanglerUtil.processItem(item, mangled, originalDemangled);
    }

    static DemangledDataType convertToDemangledDataType(MDDataType type, String mangled, String originalDemangled) {
        return MicrosoftDemanglerUtil.processDataType(null, type, mangled, originalDemangled);
    }

    private static Demangled processNamespace(MDQualifiedName qualifiedName, String mangled, String demangledSource) {
        return MicrosoftDemanglerUtil.processNamespace(qualifiedName.getQualification(), mangled, demangledSource);
    }

    private static Demangled processNamespace(MDQualification qualification, String mangled, String demangledSource) {
        Demangled type;
        Iterator it = qualification.iterator();
        if (!it.hasNext()) {
            return null;
        }
        MDQualifier qual = (MDQualifier)it.next();
        Demangled current = type = MicrosoftDemanglerUtil.getDemangled(qual, mangled, demangledSource);
        while (it.hasNext()) {
            qual = (MDQualifier)it.next();
            Demangled parent = MicrosoftDemanglerUtil.getDemangled(qual, mangled, demangledSource);
            current.setNamespace(parent);
            current = parent;
        }
        return type;
    }

    private static Demangled getDemangled(MDQualifier qual, String mangled, String demangledSource) {
        DemangledNamespaceNode demangled = null;
        if (qual.isNested()) {
            String subMangled = qual.getNested().getMangled();
            MDObjectCPP obj = qual.getNested().getNestedObject();
            if (!obj.isHashObject()) {
                MDTypeInfo typeInfo = obj.getTypeInfo();
                MDType type = typeInfo.getMDType();
                if (type instanceof MDDataType) {
                    MDDataType dt = (MDDataType)type;
                    demangled = new DemangledType(subMangled, qual.toString(), qual.toString());
                } else if (type instanceof MDFunctionType) {
                    MDFunctionType ft = (MDFunctionType)type;
                    demangled = new DemangledNamespaceNode(subMangled, qual.toString(), qual.toString());
                }
            }
            if (demangled == null) {
                demangled = new DemangledNamespaceNode(subMangled, qual.toString(), qual.toString());
            }
        } else if (qual.isAnon()) {
            String orig = qual.getAnonymousName();
            demangled = new DemangledNamespaceNode(mangled, orig, qual.toString());
        } else if (qual.isInterface()) {
            demangled = new DemangledNamespaceNode(mangled, qual.toString(), qual.toString());
        } else if (qual.isNameQ()) {
            demangled = new DemangledNamespaceNode(mangled, qual.toString(), qual.toString());
        } else if (qual.isNameC()) {
            demangled = new DemangledType(mangled, qual.toString(), qual.toString());
        } else if (qual.isLocalNamespace()) {
            String local = MDMangUtils.createStandardLocalNamespaceNode((String)qual.getLocalNamespaceNumber());
            demangled = new DemangledNamespaceNode(mangled, qual.toString(), local);
        } else {
            demangled = new DemangledNamespaceNode(mangled, qual.toString(), qual.toString());
        }
        return demangled;
    }

    private static DemangledObject processItem(MDParsableItem item, String mangled, String demangledSource) throws DemangledException {
        DemangledObject result = null;
        if (item instanceof MDObjectReserved) {
            result = MicrosoftDemanglerUtil.processObjectReserved((MDObjectReserved)item, mangled, demangledSource);
        } else if (item instanceof MDObjectCodeView) {
            MDObjectCodeView codeView = (MDObjectCodeView)item;
            result = MicrosoftDemanglerUtil.processObjectCPP((MDObjectCPP)codeView, mangled, demangledSource);
            result.setSpecialPrefix(codeView.getPrefix());
        } else if (item instanceof MDObjectCPP) {
            MDObjectCPP objCpp = (MDObjectCPP)item;
            result = MicrosoftDemanglerUtil.processObjectCPP(objCpp, mangled, demangledSource);
        } else if (item instanceof MDObjectC) {
            MDObjectC objC = (MDObjectC)item;
            result = MicrosoftDemanglerUtil.processObjectC(objC, mangled, demangledSource);
        } else {
            if (item instanceof MDDataType) {
                MDDataType dataType = (MDDataType)item;
                throw new DemangledException("DemangledDataType instead of DemangledObject");
            }
            if (item instanceof MDTemplateNameAndArguments) {
                MDTemplateNameAndArguments templateNameAndArgs = (MDTemplateNameAndArguments)item;
                result = MicrosoftDemanglerUtil.processTemplate(templateNameAndArgs, mangled, demangledSource);
            }
        }
        return result;
    }

    private static DemangledObject processObjectReserved(MDObjectReserved objectReserved, String mangled, String demangledSource) {
        DemangledUnknown object = null;
        if (objectReserved.getClass().equals(MDObjectReserved.class)) {
            return null;
        }
        if (objectReserved instanceof MDObjectBracket) {
            MDObjectBracket objectBracket = (MDObjectBracket)objectReserved;
            MDObjectCPP objectCPP = objectBracket.getObjectCPP();
            object = MicrosoftDemanglerUtil.processObjectCPP(objectCPP, mangled, demangledSource);
            object.setSpecialPrefix(objectBracket.getPrefix());
        } else {
            object = new DemangledUnknown(mangled, demangledSource, objectReserved.toString());
        }
        return object;
    }

    private static DemangledObject processObjectC(MDObjectC objectC, String mangled, String demangledSource) {
        DemangledFunction demangledFunction = MicrosoftDemanglerUtil.processObjectCFunction(objectC, mangled, demangledSource);
        if (demangledFunction != null) {
            return demangledFunction;
        }
        return null;
    }

    private static DemangledFunction processObjectCFunction(MDObjectC objectC, String mangled, String demangledSource) {
        String callingConvention = objectC.getCallingConvention();
        if (callingConvention == null) {
            return null;
        }
        DemangledFunction function = new DemangledFunction(mangled, demangledSource, objectC.getName());
        function.setSignatureSourceType(SourceType.DEFAULT);
        function.setCallingConvention(callingConvention);
        return function;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DemangledObject processObjectCPP(MDObjectCPP objectCPP, String mangled, String demangledSource) {
        MDTypeInfo typeinfo = objectCPP.getTypeInfo();
        DemangledUnknown result = null;
        if (typeinfo != null) {
            if (typeinfo instanceof MDVariableInfo) {
                DemangledVariable variable;
                MDVariableInfo variableInfo = (MDVariableInfo)typeinfo;
                MDType mdtype = variableInfo.getMDType();
                DemangledDataType dt = MicrosoftDemanglerUtil.processDataType(null, (MDDataType)mdtype, mangled, demangledSource);
                if ("std::nullptr_t".equals(dt.getName())) {
                    variable = new DemangledVariable(mangled, demangledSource, "");
                } else {
                    variable = new DemangledVariable(mangled, demangledSource, objectCPP.getName());
                    variable.setNamespace(MicrosoftDemanglerUtil.processNamespace(objectCPP.getQualification(), mangled, demangledSource));
                }
                variable.setDatatype(dt);
                result = variable;
                variable.setConst(variableInfo.isConst());
                variable.setVolatile(variableInfo.isVolatile());
                variable.setPointer64(variableInfo.isPointer64());
                if (variableInfo.isRestrict()) {
                    variable.setRestrict();
                }
                if (variableInfo.isUnaligned()) {
                    variable.setUnaligned();
                }
                variable.setBasedName(variableInfo.getBasedName());
                if (variableInfo.isMember()) {
                    variable.setMemberScope(variableInfo.getMemberScope());
                }
            } else if (typeinfo instanceof MDFunctionInfo) {
                if (typeinfo.getSpecialHandlingCode() == 'F') {
                    result = new DemangledUnknown(mangled, demangledSource, null);
                } else {
                    DemangledFunction function = new DemangledFunction(mangled, demangledSource, objectCPP.getName());
                    function.setSignatureSourceType(SourceType.IMPORTED);
                    function.setNamespace(MicrosoftDemanglerUtil.processNamespace(objectCPP.getQualification(), mangled, demangledSource));
                    result = function;
                    MicrosoftDemanglerUtil.processFunction((MDFunctionInfo)typeinfo, function, mangled, demangledSource);
                    if (!(!(typeinfo instanceof MDMemberFunctionInfo) || typeinfo instanceof MDVCall || typeinfo instanceof MDVFAdjustor || typeinfo instanceof MDVtordisp || typeinfo instanceof MDVtordispex)) {
                        // empty if block
                    }
                }
            } else if (typeinfo instanceof MDVxTable) {
                MDVxTable vxtable = (MDVxTable)typeinfo;
                DemangledVariable variable = new DemangledVariable(mangled, demangledSource, objectCPP.getName());
                variable.setNamespace(MicrosoftDemanglerUtil.processNamespace(objectCPP.getQualification(), mangled, demangledSource));
                variable.setConst(vxtable.isConst());
                variable.setVolatile(vxtable.isVolatile());
                variable.setPointer64(vxtable.isPointer64());
                result = variable;
            } else if (typeinfo instanceof AbstractMDMetaClass) {
                DemangledVariable variable = new DemangledVariable(mangled, demangledSource, objectCPP.getName());
                variable.setNamespace(MicrosoftDemanglerUtil.processNamespace(objectCPP.getQualification(), mangled, demangledSource));
                result = variable;
            } else if (typeinfo instanceof MDGuard) {
                DemangledVariable variable = new DemangledVariable(mangled, demangledSource, objectCPP.getName());
                variable.setNamespace(MicrosoftDemanglerUtil.processNamespace(objectCPP.getQualification(), mangled, demangledSource));
                result = variable;
            } else {
                DemangledVariable variable = new DemangledVariable(mangled, demangledSource, objectCPP.getName());
                variable.setNamespace(MicrosoftDemanglerUtil.processNamespace(objectCPP.getQualification(), mangled, demangledSource));
                result = variable;
            }
            if (typeinfo.isPrivate()) {
                result.setVisibilty("private");
            } else if (typeinfo.isProtected()) {
                result.setVisibilty("protected");
            } else if (typeinfo.isPublic()) {
                result.setVisibilty("public");
            }
            result.setStatic(typeinfo.isStatic());
            result.setVirtual(typeinfo.isVirtual());
            result.setThunk(typeinfo.isThunk());
            if (!typeinfo.isExternC()) return result;
            result.setSpecialPrefix("extern \"C\"");
            return result;
        }
        String baseName = objectCPP.getName();
        if (objectCPP.isString()) {
            MDString mstring = objectCPP.getMDString();
            DemangledString demangledString = new DemangledString(mangled, demangledSource, mstring.getName(), mstring.toString(), mstring.getLength(), mstring.isUnicode());
            return demangledString;
        }
        if (baseName.length() == 0) return result;
        DemangledVariable variable = new DemangledVariable(mangled, demangledSource, baseName);
        variable.setNamespace(MicrosoftDemanglerUtil.processNamespace(objectCPP.getQualification(), mangled, demangledSource));
        return variable;
    }

    private static DemangledVariable processTemplate(MDTemplateNameAndArguments template, String mangled, String demangledSource) {
        DemangledVariable variable = new DemangledVariable(mangled, demangledSource, template.toString());
        return variable;
    }

    private static DemangledFunction processFunction(MDFunctionInfo functionInfo, DemangledFunction function, String mangled, String demangledSource) {
        MDThrowAttribute ta;
        MDCVMod thisPointerCVMod;
        MDDataType retType;
        MDFunctionType functionType = (MDFunctionType)functionInfo.getMDType();
        String convention = functionType.getCallingConvention().toString();
        if ("__cdecl".equals(convention) && functionInfo.isMember() && !functionInfo.isStatic()) {
            convention = "__thiscall";
        }
        function.setCallingConvention(convention);
        if (functionType.hasReturn() && functionType.getReturnType() != null && !(retType = functionType.getReturnType()).toString().isEmpty()) {
            function.setReturnType(MicrosoftDemanglerUtil.processDataType(null, retType, mangled, demangledSource));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                function.addParameter(new DemangledParameter(MicrosoftDemanglerUtil.processDataType(null, args.getArg(index), mangled, demangledSource)));
            }
        }
        if (functionType.isTypeCast()) {
            function.setTypeCast();
        }
        if ((thisPointerCVMod = functionType.getThisPointerCVMod()) != null) {
            if (thisPointerCVMod.isConst()) {
                function.setTrailingConst();
            }
            if (thisPointerCVMod.isVolatile()) {
                function.setTrailingVolatile();
            }
            if (thisPointerCVMod.isPointer64()) {
                function.setTrailingPointer64();
            }
            if (thisPointerCVMod.isRestricted()) {
                function.setTrailingRestrict();
            }
            if (thisPointerCVMod.isUnaligned()) {
                function.setTrailingUnaligned();
            }
        }
        if ((ta = functionType.getThrowAttribute()) != null) {
            function.setThrowAttribute(ta.toString());
        }
        return function;
    }

    private static DemangledFunctionPointer processDemangledFunctionPointer(MDPointerType pointerType, String mangled, String demangledSource) {
        MDCVMod thisPointerCVMod;
        DemangledFunctionPointer functionPointer = new DemangledFunctionPointer(mangled, demangledSource);
        MDFunctionType functionType = (MDFunctionType)pointerType.getReferencedType();
        functionPointer.setCallingConvention(functionType.getCallingConvention().toString());
        functionPointer.setModifier(pointerType.getCVMod().toString());
        if (functionType.hasReturn() && functionType.getReturnType() != null) {
            functionPointer.setReturnType(MicrosoftDemanglerUtil.processDataType(null, functionType.getReturnType(), mangled, demangledSource));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                functionPointer.addParameter(MicrosoftDemanglerUtil.processDataType(null, args.getArg(index), mangled, demangledSource));
            }
        }
        if ((thisPointerCVMod = functionType.getThisPointerCVMod()) != null) {
            if (thisPointerCVMod.isConst()) {
                functionPointer.setConst();
            }
            if (thisPointerCVMod.isVolatile()) {
                functionPointer.setVolatile();
            }
            if (thisPointerCVMod.isPointer64()) {
                functionPointer.setTrailingPointer64();
            }
            if (thisPointerCVMod.isRestricted()) {
                functionPointer.setTrailingRestrict();
            }
            if (thisPointerCVMod.isUnaligned()) {
                functionPointer.setTrailingUnaligned();
            }
        }
        return functionPointer;
    }

    private static DemangledFunctionReference processDemangledFunctionReference(MDModifierType refType, String mangled, String demangledSource) {
        if (!(refType instanceof MDReferenceType) && !(refType instanceof MDDataRightReferenceType)) {
            return null;
        }
        DemangledFunctionReference functionReference = new DemangledFunctionReference(mangled, demangledSource);
        MDFunctionType functionType = (MDFunctionType)refType.getReferencedType();
        functionReference.setCallingConvention(functionType.getCallingConvention().toString());
        functionReference.setModifier(refType.getCVMod().toString());
        if (functionType.hasReturn() && functionType.getReturnType() != null) {
            functionReference.setReturnType(MicrosoftDemanglerUtil.processDataType(null, functionType.getReturnType(), mangled, demangledSource));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                functionReference.addParameter(MicrosoftDemanglerUtil.processDataType(null, args.getArg(index), mangled, demangledSource));
            }
        }
        return functionReference;
    }

    private static DemangledFunctionIndirect processDemangledFunctionIndirect(MDFunctionIndirectType functionIndirectType, String mangled, String demangledSource) {
        DemangledFunctionIndirect functionDefinition = new DemangledFunctionIndirect(mangled, demangledSource);
        MDFunctionType functionType = (MDFunctionType)functionIndirectType.getReferencedType();
        functionDefinition.setCallingConvention(functionType.getCallingConvention().toString());
        functionDefinition.setModifier(functionIndirectType.getCVMod().toString());
        functionDefinition.incrementPointerLevels();
        if (functionType.hasReturn() && functionType.getReturnType() != null) {
            functionDefinition.setReturnType(MicrosoftDemanglerUtil.processDataType(null, functionType.getReturnType(), mangled, demangledSource));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                functionDefinition.addParameter(MicrosoftDemanglerUtil.processDataType(null, args.getArg(index), mangled, demangledSource));
            }
        }
        return functionDefinition;
    }

    private static DemangledFunctionIndirect processDemangledFunctionQuestion(MDModifierType modifierType, String mangled, String demangledSource) {
        DemangledFunctionIndirect functionDefinition = new DemangledFunctionIndirect(mangled, demangledSource);
        MDFunctionType functionType = (MDFunctionType)modifierType.getReferencedType();
        functionDefinition.setCallingConvention(functionType.getCallingConvention().toString());
        functionDefinition.setModifier(modifierType.getCVMod().toString());
        functionDefinition.incrementPointerLevels();
        if (functionType.hasReturn() && functionType.getReturnType() != null) {
            functionDefinition.setReturnType(MicrosoftDemanglerUtil.processDataType(null, functionType.getReturnType(), mangled, demangledSource));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                functionDefinition.addParameter(MicrosoftDemanglerUtil.processDataType(null, args.getArg(index), mangled, demangledSource));
            }
        }
        return functionDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DemangledDataType processDataType(DemangledDataType resultDataType, MDDataType datatype, String mangled, String demangledSource) {
        if (resultDataType == null) {
            resultDataType = new DemangledDataType(mangled, demangledSource, MicrosoftDemanglerUtil.getDataTypeName(datatype));
        }
        if (datatype.isSpecifiedSigned()) {
            resultDataType.setSigned();
        }
        if (datatype.isUnsigned()) {
            resultDataType.setUnsigned();
        }
        if (datatype instanceof MDModifierType) {
            MDModifierType modifierType = (MDModifierType)datatype;
            if (modifierType.isConst()) {
                resultDataType.setConst();
            }
            if (modifierType.isVolatile()) {
                resultDataType.setVolatile();
            }
            if (modifierType.isPointer64()) {
                resultDataType.setPointer64();
            }
            if (modifierType.isRestrict()) {
                resultDataType.setRestrict();
            }
            if (modifierType.isUnaligned()) {
                resultDataType.setUnaligned();
            }
            resultDataType.setBasedName(modifierType.getBasedName());
            resultDataType.setMemberScope(modifierType.getMemberScope());
            if (modifierType instanceof MDArrayBasicType) {
                resultDataType.setArray(1);
                if (modifierType.getReferencedType() instanceof MDFunctionType || !(modifierType.getReferencedType() instanceof MDDataType)) return resultDataType;
                return MicrosoftDemanglerUtil.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType(), mangled, demangledSource);
            }
            if (modifierType instanceof MDPointerType) {
                if (modifierType.getReferencedType() instanceof MDFunctionType) {
                    DemangledFunctionPointer fp = MicrosoftDemanglerUtil.processDemangledFunctionPointer((MDPointerType)modifierType, mangled, demangledSource);
                    for (int i = 0; i < resultDataType.getPointerLevels(); ++i) {
                        fp.incrementPointerLevels();
                    }
                    if (resultDataType.isConst()) {
                        fp.setConst();
                    }
                    if (resultDataType.isVolatile()) {
                        fp.setVolatile();
                    }
                    if (!resultDataType.isPointer64()) return fp;
                    fp.setPointer64();
                    return fp;
                }
                DemangledDataType newResult = MicrosoftDemanglerUtil.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType(), mangled, demangledSource);
                newResult.incrementPointerLevels();
                if (modifierType.getCVMod().isConst()) {
                    newResult.setConst();
                }
                if (modifierType.getCVMod().isVolatile()) {
                    newResult.setVolatile();
                }
                if (!modifierType.getCVMod().isPointer64()) return newResult;
                newResult.setPointer64();
                return newResult;
            }
            if (modifierType instanceof MDReferenceType) {
                if (modifierType.getReferencedType() instanceof MDFunctionType) {
                    DemangledFunctionReference fr = MicrosoftDemanglerUtil.processDemangledFunctionReference(modifierType, mangled, demangledSource);
                    for (int i = 0; i < resultDataType.getPointerLevels(); ++i) {
                        fr.incrementPointerLevels();
                    }
                    if (resultDataType.isConst()) {
                        fr.setConst();
                    }
                    if (resultDataType.isVolatile()) {
                        fr.setVolatile();
                    }
                    if (!resultDataType.isPointer64()) return fr;
                    fr.setPointer64();
                    return fr;
                }
                DemangledDataType newResult = MicrosoftDemanglerUtil.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType(), mangled, demangledSource);
                newResult.setLValueReference();
                if (modifierType.getCVMod().isConst()) {
                    newResult.setConst();
                }
                if (modifierType.getCVMod().isVolatile()) {
                    newResult.setVolatile();
                }
                if (!modifierType.getCVMod().isPointer64()) return newResult;
                newResult.setPointer64();
                return newResult;
            }
            if (modifierType instanceof MDFunctionIndirectType) {
                DemangledFunctionIndirect fd = MicrosoftDemanglerUtil.processDemangledFunctionIndirect((MDFunctionIndirectType)modifierType, mangled, demangledSource);
                for (int i = 0; i < resultDataType.getPointerLevels(); ++i) {
                    fd.incrementPointerLevels();
                }
                if (resultDataType.isConst()) {
                    fd.setConst();
                }
                if (resultDataType.isVolatile()) {
                    fd.setVolatile();
                }
                if (!resultDataType.isPointer64()) return fd;
                fd.setPointer64();
                return fd;
            }
            if (modifierType instanceof MDPointerRefDataType) {
                resultDataType.setName(MicrosoftDemanglerUtil.getDataTypeName(datatype));
                return MicrosoftDemanglerUtil.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType(), mangled, demangledSource);
            }
            if (modifierType instanceof MDDataReferenceType) {
                MicrosoftDemanglerUtil.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType(), mangled, demangledSource);
                if (modifierType.getCVMod().isConst()) {
                    resultDataType.setConst();
                }
                if (!modifierType.getCVMod().isVolatile()) return resultDataType;
                resultDataType.setVolatile();
                return resultDataType;
            }
            if (modifierType instanceof MDDataRightReferenceType) {
                if (modifierType.getReferencedType() instanceof MDFunctionType) {
                    resultDataType.setName(MicrosoftDemanglerUtil.getDataTypeName(datatype));
                    DemangledFunctionReference fr = MicrosoftDemanglerUtil.processDemangledFunctionReference(modifierType, mangled, demangledSource);
                    for (int i = 0; i < resultDataType.getPointerLevels(); ++i) {
                        fr.incrementPointerLevels();
                    }
                    if (resultDataType.isConst()) {
                        fr.setConst();
                    }
                    if (resultDataType.isVolatile()) {
                        fr.setVolatile();
                    }
                    if (!resultDataType.isPointer64()) return fr;
                    fr.setPointer64();
                    return fr;
                }
                MicrosoftDemanglerUtil.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType(), mangled, demangledSource);
                resultDataType.setRValueReference();
                if (modifierType.getCVMod().isConst()) {
                    resultDataType.setConst();
                }
                if (modifierType.getCVMod().isVolatile()) {
                    resultDataType.setVolatile();
                }
                if (!modifierType.getCVMod().isPointer64()) return resultDataType;
                resultDataType.setPointer64();
                return resultDataType;
            }
            if (modifierType.getReferencedType() instanceof MDFunctionType) {
                DemangledFunctionIndirect fx = MicrosoftDemanglerUtil.processDemangledFunctionQuestion(modifierType, mangled, demangledSource);
                if (resultDataType.isConst()) {
                    fx.setConst();
                }
                if (resultDataType.isVolatile()) {
                    fx.setVolatile();
                }
                if (!resultDataType.isPointer64()) return fx;
                fx.setPointer64();
                return fx;
            }
            DemangledDataType dataType = MicrosoftDemanglerUtil.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType(), mangled, demangledSource);
            if (modifierType.getCVMod().isConst()) {
                resultDataType.setConst();
            }
            if (modifierType.getCVMod().isVolatile()) {
                resultDataType.setVolatile();
            }
            if (!modifierType.getCVMod().isPointer64()) return dataType;
            resultDataType.setPointer64();
            return dataType;
        }
        if (datatype instanceof MDComplexType) {
            MDComplexType complexType = (MDComplexType)datatype;
            resultDataType.setName(complexType.getNamespace().getName());
            resultDataType.setNamespace(MicrosoftDemanglerUtil.processNamespace(complexType.getNamespace(), mangled, demangledSource));
            if (datatype instanceof MDEnumType) {
                resultDataType.setEnum();
                MDEnumType enumType = (MDEnumType)datatype;
                resultDataType.setEnumType(enumType.getUnderlyingFullTypeName());
                return resultDataType;
            } else if (datatype instanceof MDClassType) {
                resultDataType.setClass();
                return resultDataType;
            } else if (datatype instanceof MDStructType) {
                resultDataType.setStruct();
                return resultDataType;
            } else if (datatype instanceof MDUnionType) {
                resultDataType.setUnion();
                return resultDataType;
            } else if (datatype instanceof MDCoclassType) {
                resultDataType.setCoclass();
                return resultDataType;
            } else {
                if (!(datatype instanceof MDCointerfaceType)) return resultDataType;
                resultDataType.setCointerface();
            }
            return resultDataType;
        } else if (datatype instanceof MDReferenceType) {
            resultDataType.setLValueReference();
            return resultDataType;
        } else if (datatype instanceof MDArrayBasicType) {
            resultDataType.setArray(1);
            return resultDataType;
        } else if (datatype instanceof MDVarArgsType) {
            resultDataType.setVarArgs();
            return resultDataType;
        } else {
            if (datatype instanceof MDArrayReferencedType) {
                MDArrayReferencedType arrRefType = (MDArrayReferencedType)datatype;
                return MicrosoftDemanglerUtil.processDataType(resultDataType, arrRefType.getReferencedType(), mangled, demangledSource);
            }
            if (datatype instanceof MDStdNullPtrType) {
                resultDataType.setName(datatype.toString());
                return resultDataType;
            } else {
                resultDataType.setName(MicrosoftDemanglerUtil.getDataTypeName(datatype));
            }
        }
        return resultDataType;
    }

    private static String getDataTypeName(MDDataType dataType) {
        String name = dataType.getName();
        if (!name.isBlank()) {
            return name;
        }
        name = dataType.getTypeName();
        if (!name.isBlank()) {
            return name;
        }
        return dataType.toString();
    }
}

