/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.X86_32_ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;

public class X86_32_ElfRelocationHandler
extends AbstractElfRelocationHandler<X86_32_ElfRelocationType, ElfRelocationContext<?>> {
    public X86_32_ElfRelocationHandler() {
        super(X86_32_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 3;
    }

    public int getRelrRelocationType() {
        return X86_32_ElfRelocationType.R_386_RELATIVE.typeId;
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, X86_32_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        long addend = relocation.hasAddend() ? relocation.getAddend() : (long)memory.getInt(relocationAddress);
        long offset = (int)relocationAddress.getOffset();
        int symbolIndex = relocation.getSymbolIndex();
        int byteLength = 4;
        switch (type) {
            case R_386_RELATIVE: {
                long base = program.getImageBase().getOffset();
                int value = elfRelocationContext.getElfHeader().isPreLinked() ? memory.getInt(relocationAddress) + (int)elfRelocationContext.getImageBaseWordAdjustmentOffset() : (int)(base + addend);
                memory.setInt(relocationAddress, value);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_386_IRELATIVE: {
                this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Indirect computed relocation not supported", elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case R_386_GOTPC: {
                try {
                    long dotgot = elfRelocationContext.getGOTValue();
                    int value = (int)(dotgot + addend - offset);
                    memory.setInt(relocationAddress, value);
                }
                catch (NotFoundException e) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, e.getMessage(), elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_386_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case R_386_TLS_DTPMOD32: 
            case R_386_TLS_DTPOFF32: 
            case R_386_TLS_TPOFF32: 
            case R_386_TLS_TPOFF: {
                this.markAsWarning(program, relocationAddress, type, symbolName, symbolIndex, "Thread Local Symbol relocation not supported", elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        switch (type) {
            case R_386_32: {
                int value = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, value);
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                X86_32_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                X86_32_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_386_PC32: {
                int value = (int)(symbolValue + addend - offset);
                memory.setInt(relocationAddress, value);
                break;
            }
            case R_386_GOT32: {
                int value = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, value);
                break;
            }
            case R_386_PLT32: {
                int value = (int)(symbolValue + addend - offset);
                memory.setInt(relocationAddress, value);
                break;
            }
            case R_386_GLOB_DAT: 
            case R_386_JMP_SLOT: {
                int value = (int)symbolValue;
                memory.setInt(relocationAddress, value);
                break;
            }
            case R_386_GOTOFF: {
                try {
                    long dotgot = elfRelocationContext.getGOTValue();
                    int value = (int)symbolValue + (int)addend - (int)dotgot;
                    memory.setInt(relocationAddress, value);
                    break;
                }
                catch (NotFoundException e) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, e.getMessage(), elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

