/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.lifecycle.Unfinished;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.mem.MemBufferMixin;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceIteratorAdapter;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.listing.DBTraceCommentAdapter;
import ghidra.trace.database.program.DBTraceVariableSnapProgramView;
import ghidra.trace.database.symbol.DBTraceReference;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.property.TracePropertyMap;
import ghidra.trace.model.property.TracePropertyMapSpace;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import ghidra.util.Saveable;
import ghidra.util.exception.NoValueException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.apache.commons.collections4.IteratorUtils;

public interface DBTraceCodeUnitAdapter
extends TraceCodeUnit,
MemBufferMixin {
    @Override
    public DBTrace getTrace();

    @Override
    default public TraceProgramView getProgram() {
        TraceThread thread = this.getThread();
        DBTraceVariableSnapProgramView view = this.getTrace().getProgramView();
        if (thread == null) {
            return view;
        }
        return Objects.requireNonNull(view.getViewRegisters(thread, false));
    }

    default public String getAddressString(boolean showBlockName, boolean pad) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().readLock());){
            Address address = this.getAddress();
            if (!showBlockName) {
                String string = address.toString(false, pad);
                return string;
            }
            TraceMemoryRegion region = this.getTrace().getMemoryManager().getRegionContaining(this.getStartSnap(), address);
            if (region == null) {
                String string = address.toString(showBlockName, pad);
                return string;
            }
            String string = region.getName(this.getStartSnap()) + ":" + address.toString(false, pad);
            return string;
        }
    }

    @Override
    default public <T> void setProperty(String name, Class<T> valueClass, T value) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().writeLock());){
            TracePropertyMap<T> map = this.getTrace().getInternalAddressPropertyManager().getOrCreatePropertyMapSuper(name, valueClass);
            TracePropertyMapSpace<T> space = map.getPropertyMapSpace(this.getTraceSpace(), true);
            space.set(this.getLifespan(), this.getAddress(), value);
        }
    }

    @Override
    default public <T, U extends T> void setTypedProperty(String name, T value) {
        Class<?> valueClass = value.getClass();
        this.setProperty(name, valueClass, valueClass.cast(value));
    }

    default public void setProperty(String name, Saveable value) {
        this.setTypedProperty(name, value);
    }

    default public void setProperty(String name, String value) {
        this.setProperty(name, String.class, value);
    }

    default public void setProperty(String name, int value) {
        this.setProperty(name, Integer.class, value);
    }

    default public void setProperty(String name) {
        this.setProperty(name, Void.class, null);
    }

    @Override
    default public <T> T getProperty(String name, Class<T> valueClass) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().readLock());){
            TracePropertyMap<T> map = this.getTrace().getInternalAddressPropertyManager().getPropertyMapExtends(name, valueClass);
            if (map == null) {
                T t = null;
                return t;
            }
            TracePropertyMapSpace<T> space = map.getPropertyMapSpace(this.getTraceSpace(), false);
            if (space == null) {
                T t = null;
                return t;
            }
            Object t = space.get(this.getStartSnap(), this.getAddress());
            return t;
        }
    }

    default public Saveable getObjectProperty(String name) {
        return this.getProperty(name, Saveable.class);
    }

    default public String getStringProperty(String name) {
        return this.getProperty(name, String.class);
    }

    default public int getIntProperty(String name) throws NoValueException {
        Integer value = this.getProperty(name, Integer.class);
        if (value == null) {
            throw new NoValueException();
        }
        return value;
    }

    default public boolean hasProperty(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().readLock());){
            TracePropertyMap<?> map = this.getTrace().getInternalAddressPropertyManager().getPropertyMap(name);
            if (map == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = map.getAddressSetView(Lifespan.at(this.getStartSnap())).contains(this.getAddress());
            return bl;
        }
    }

    default public boolean getVoidProperty(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().readLock());){
            TracePropertyMap map = this.getTrace().getInternalAddressPropertyManager().getPropertyMap(name, Void.class);
            if (map == null) {
                boolean bl = false;
                return bl;
            }
            TracePropertyMapSpace space = map.getPropertyMapSpace(this.getTraceSpace(), false);
            if (space == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = map.getAddressSetView(Lifespan.at(this.getStartSnap())).contains(this.getAddress());
            return bl;
        }
    }

    default public Iterator<String> propertyNames() {
        Lifespan span = Lifespan.at(this.getStartSnap());
        return IteratorUtils.transformedIterator((Iterator)IteratorUtils.filteredIterator(this.getTrace().getInternalAddressPropertyManager().getAllProperties().entrySet().iterator(), e -> ((TracePropertyMap)e.getValue()).getAddressSetView(span).contains(this.getAddress())), Map.Entry::getKey);
    }

    default public void removeProperty(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.getTrace().getReadWriteLock().writeLock());){
            TracePropertyMap<?> map = this.getTrace().getInternalAddressPropertyManager().getPropertyMap(name);
            if (map == null) {
                return;
            }
            map.clear(this.getLifespan(), (AddressRange)new AddressRangeImpl(this.getMinAddress(), this.getMaxAddress()));
        }
    }

    default public String getLabel() {
        try (LockHold hold = this.getTrace().lockRead();){
            Symbol primary = this.getPrimarySymbol();
            String string = primary == null ? null : primary.getName();
            return string;
        }
    }

    default public Symbol[] getSymbols() {
        try (LockHold hold = this.getTrace().lockRead();){
            Collection<TraceSymbol> at = this.getTrace().getSymbolManager().labels().getAt(this.getStartSnap(), this.getThread(), this.getAddress(), true);
            Symbol[] symbolArray = at.toArray(new TraceSymbol[at.size()]);
            return symbolArray;
        }
    }

    default public Symbol getPrimarySymbol() {
        try (LockHold hold = this.getTrace().lockRead();){
            Collection at = this.getTrace().getSymbolManager().labels().getAt(this.getStartSnap(), this.getThread(), this.getAddress(), true);
            if (at.isEmpty()) {
                Symbol symbol = null;
                return symbol;
            }
            Symbol symbol = (Symbol)at.iterator().next();
            return symbol;
        }
    }

    default public Address getMinAddress() {
        return this.getAddress();
    }

    default public void setComment(CommentType commentType, String comment) {
        if (this.getThread() != null) {
            Unfinished.TODO();
        }
        this.getTrace().getCommentAdapter().setComment(this.getLifespan(), this.getAddress(), commentType, comment);
    }

    default public String getComment(CommentType commentType) {
        if (this.getThread() != null) {
            return null;
        }
        return this.getTrace().getCommentAdapter().getComment(this.getStartSnap(), this.getAddress(), commentType);
    }

    default public void setCommentAsArray(CommentType commentType, String[] comment) {
        this.setComment(commentType, DBTraceCommentAdapter.commentFromArray(comment));
    }

    default public String[] getCommentAsArray(CommentType commentType) {
        return DBTraceCommentAdapter.arrayFromComment(this.getComment(commentType));
    }

    default public boolean contains(Address testAddr) {
        return this.getMinAddress().compareTo((Object)testAddr) <= 0 && testAddr.compareTo((Object)this.getMaxAddress()) <= 0;
    }

    default public int compareTo(Address addr) {
        if (addr.compareTo((Object)this.getMinAddress()) < 0) {
            return -1;
        }
        if (addr.compareTo((Object)this.getMaxAddress()) > 0) {
            return 1;
        }
        return 0;
    }

    default public void addMnemonicReference(Address refAddr, RefType refType, SourceType sourceType) {
        this.getTrace().getReferenceManager().addMemoryReference(this.getLifespan(), this.getAddress(), refAddr, refType, sourceType, -1);
    }

    default public void addOperandReference(int index, Address refAddr, RefType type, SourceType sourceType) {
        this.getTrace().getReferenceManager().addMemoryReference(this.getLifespan(), this.getAddress(), refAddr, type, sourceType, index);
    }

    default public void setPrimaryMemoryReference(Reference ref) {
        DBTraceReference dbRef = this.getTrace().getReferenceManager().assertIsMine(ref);
        dbRef.setPrimary(true);
    }

    default public void setStackReference(int opIndex, int offset, SourceType sourceType, RefType refType) {
        this.getTrace().getReferenceManager().addStackReference(this.getLifespan(), this.getAddress(), offset, refType, sourceType, opIndex);
    }

    default public void setRegisterReference(int opIndex, Register reg, SourceType sourceType, RefType refType) {
        this.getTrace().getReferenceManager().addRegisterReference(this.getLifespan(), this.getAddress(), reg, refType, sourceType, opIndex);
    }

    default public DBTraceReference[] getMnemonicReferences() {
        return this.getOperandReferences(-1);
    }

    default public DBTraceReference[] getOperandReferences(int index) {
        Collection<? extends DBTraceReference> refs = this.getTrace().getReferenceManager().getReferencesFrom(this.getStartSnap(), this.getAddress(), index);
        return refs.toArray(new DBTraceReference[refs.size()]);
    }

    @Override
    default public DBTraceReference getPrimaryReference(int index) {
        return this.getTrace().getReferenceManager().getPrimaryReferenceFrom(this.getStartSnap(), this.getAddress(), index);
    }

    default public DBTraceReference[] getReferencesFrom() {
        Collection<? extends DBTraceReference> refs = this.getTrace().getReferenceManager().getReferencesFrom(this.getStartSnap(), this.getAddress());
        return refs.toArray(new DBTraceReference[refs.size()]);
    }

    default public ReferenceIterator getReferenceIteratorTo() {
        return new ReferenceIteratorAdapter(this.getTrace().getReferenceManager().getReferencesTo(this.getStartSnap(), this.getAddress()).iterator());
    }

    default public ExternalReference getExternalReference(int opIndex) {
        return null;
    }

    default public void removeMnemonicReference(Address refAddr) {
        this.removeOperandReference(-1, refAddr);
    }

    default public void removeOperandReference(int index, Address refAddr) {
        DBTraceReference ref = this.getTrace().getReferenceManager().getReference(this.getStartSnap(), this.getAddress(), refAddr, index);
        if (ref == null) {
            return;
        }
        ref.delete();
    }

    default public void removeExternalReference(int opIndex) {
        throw new UnsupportedOperationException();
    }

    default public Memory getMemory() {
        return this.getProgram().getMemory();
    }

    default public boolean isBigEndian() {
        return this.getLanguage().isBigEndian();
    }

    default public byte[] getBytes() throws MemoryAccessException {
        return this.getBytesInFull(0, this.getLength()).array();
    }

    default public void getBytesInCodeUnit(byte[] buffer, int bufferOffset) throws MemoryAccessException {
        int len = Math.min(buffer.length - bufferOffset, this.getLength());
        if (this.getBytes(ByteBuffer.wrap(buffer, bufferOffset, len), 0) != len) {
            throw new MemoryAccessException("Couldn't get requested bytes for CodeUnit");
        }
    }
}

