/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.symbol.DBTraceEquate;
import ghidra.trace.database.symbol.DBTraceEquateSpace;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.symbol.TraceEquateManager;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import ghidra.util.UnionAddressSetView;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceEquateManager
extends AbstractDBTraceSpaceBasedManager<DBTraceEquateSpace>
implements TraceEquateManager,
DBTraceDelegatingManager<DBTraceEquateSpace> {
    public static final String NAME = "Equate";
    protected final DBCachedObjectStore<DBTraceEquate> equateStore;
    protected final Collection<DBTraceEquate> equateView;
    protected final DBCachedObjectIndex<String, DBTraceEquate> equatesByName;
    protected final DBCachedObjectIndex<Long, DBTraceEquate> equatesByValue;

    public DBTraceEquateManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws VersionException, IOException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.equateStore = factory.getOrCreateCachedStore("Equates", DBTraceEquate.class, (s, r) -> new DBTraceEquate(this, (DBCachedObjectStore<DBTraceEquate>)s, r), true);
        this.equateView = Collections.unmodifiableCollection(this.equateStore.asMap().values());
        this.equatesByName = this.equateStore.getIndex(String.class, DBTraceEquate.NAME_COLUMN);
        this.equatesByValue = this.equateStore.getIndex(Long.TYPE, DBTraceEquate.VALUE_COLUMN);
        this.loadSpaces();
    }

    @Override
    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.equateStore.invalidateCache();
            super.invalidateCache(all);
        }
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    public DBTraceEquateSpace getEquateSpace(AddressSpace space, boolean createIfAbsent) {
        return this.getForSpace(space, createIfAbsent);
    }

    @Override
    public DBTraceEquateSpace getEquateRegisterSpace(TraceThread thread, boolean createIfAbsent) {
        return (DBTraceEquateSpace)this.getForRegisterSpace(thread, 0, createIfAbsent);
    }

    @Override
    public DBTraceEquateSpace getEquateRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        return (DBTraceEquateSpace)this.getForRegisterSpace(frame, createIfAbsent);
    }

    @Override
    protected DBTraceEquateSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceEquateSpace(this, this.dbh, space, ent, null);
    }

    @Override
    protected DBTraceEquateSpace createRegisterSpace(AddressSpace space, TraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceEquateSpace(this, this.dbh, space, ent, thread);
    }

    @Override
    public DBTraceEquateSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceEquateSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public DBTraceEquate create(String newName, long value) throws DuplicateNameException, IllegalArgumentException {
        TraceEquateManager.validateName(newName);
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceEquate equate = (DBTraceEquate)this.equatesByName.getOne((Object)newName);
            if (equate != null) {
                throw new DuplicateNameException("Equate already exists: " + newName);
            }
            equate = (DBTraceEquate)this.equateStore.create();
            equate.set(newName, value);
            DBTraceEquate dBTraceEquate = equate;
            return dBTraceEquate;
        }
    }

    public Collection<? extends DBTraceEquate> getAll() {
        return this.equateView;
    }

    @Override
    public DBTraceEquate getByName(String equateName) {
        return (DBTraceEquate)this.equatesByName.getOne((Object)equateName);
    }

    @Override
    public DBTraceEquate getByKey(long key) {
        return (DBTraceEquate)this.equateStore.getObjectAt(key);
    }

    public Collection<? extends DBTraceEquate> getByValue(long value) {
        return Collections.unmodifiableCollection(this.equatesByValue.get((Object)value));
    }

    protected void doDelete(DBTraceEquate equate) {
        this.equateStore.delete((DBAnnotatedObject)equate);
    }

    @Override
    public AddressSetView getReferringAddresses(Lifespan span) {
        return new UnionAddressSetView(this.memSpacesView.stream().map(m -> m.getReferringAddresses(span)).toList());
    }

    @Override
    public void clearReferences(Lifespan span, AddressSetView asv, TaskMonitor monitor) throws CancelledException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (AddressRange range : asv) {
                this.clearReferences(span, range, monitor);
            }
        }
    }

    @Override
    public void clearReferences(Lifespan span, AddressRange range, TaskMonitor monitor) throws CancelledException {
        this.delegateDeleteV(range.getAddressSpace(), m -> m.clearReferences(span, range, monitor));
    }

    @Override
    public DBTraceEquate getReferencedByValue(long snap, Address address, int operandIndex, long value) {
        return (DBTraceEquate)this.delegateRead(address.getAddressSpace(), m -> m.getReferencedByValue(snap, address, operandIndex, value));
    }

    public Collection<? extends DBTraceEquate> getReferenced(long snap, Address address, int operandIndex) {
        return (Collection)this.delegateRead(address.getAddressSpace(), m -> m.getReferenced(snap, address, operandIndex), Collections.emptyList());
    }

    public Collection<? extends DBTraceEquate> getReferenced(long snap, Address address) {
        return (Collection)this.delegateRead(address.getAddressSpace(), m -> m.getReferenced(snap, address), Collections.emptyList());
    }
}

