/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.StringFormat;
import ghidra.util.classfinder.ClassTranslator;

public class Undefined7DataType
extends Undefined {
    private static final long serialVersionUID = 1L;
    public static final Undefined7DataType dataType;

    public Undefined7DataType() {
        this(null);
    }

    public Undefined7DataType(DataTypeManager dtm) {
        super("undefined7", dtm);
    }

    @Override
    public int getLength() {
        return 7;
    }

    @Override
    public String getDescription() {
        return "Undefined 7-Byte";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    private long getValue(MemBuffer buf) throws MemoryAccessException {
        long val = (long)(buf.getInt(0) << 24) + (((long)buf.getShort(4) & 0xFFFFL) << 8) + ((long)buf.getByte(6) & 0xFFL);
        return val & 0xFFFFFFFFFFFFL;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        String val = "??";
        try {
            long b = this.getValue(buf);
            val = Long.toHexString(b).toUpperCase();
            val = StringFormat.padIt((String)val, (int)14, (char)'h', (boolean)true);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return val;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            return new Scalar(56, this.getValue(buf));
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new Undefined7DataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.Undefined7", (String)Undefined7DataType.class.getName());
        dataType = new Undefined7DataType();
    }
}

