/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import ghidra.bitpatterns.info.PatternEvalRowObject;
import java.util.ArrayList;
import java.util.List;

public class PatternEvaluationStats {
    private int truePositives = 0;
    private int possible_start_code = 0;
    private int fp_wrong_flow = 0;
    private int fp_misaligned = 0;
    private int fp_data = 0;
    private int inUndefined = 0;
    private int contextConflicts = 0;
    private int pre_pattern_hit = 0;
    private List<PatternEvalRowObject> rowObjects = new ArrayList<PatternEvalRowObject>();

    public int getNumTruePositives() {
        return this.truePositives;
    }

    private void incTruePositives() {
        ++this.truePositives;
    }

    public int getNumPossibleStartCode() {
        return this.possible_start_code;
    }

    private void incNumPossibleStartCode() {
        ++this.possible_start_code;
    }

    public int getNumWrongFlow() {
        return this.fp_wrong_flow;
    }

    private void incNumFPWithinBlock() {
        ++this.fp_wrong_flow;
    }

    public int getNumFPMisaligned() {
        return this.fp_misaligned;
    }

    private void incNumFPMisaligned() {
        ++this.fp_misaligned;
    }

    public int getNumFPData() {
        return this.fp_data;
    }

    private void incNumFPData() {
        ++this.fp_data;
    }

    public int getNumUndefined() {
        return this.inUndefined;
    }

    private void incNumUndefined() {
        ++this.inUndefined;
    }

    private void incNumContextConflicts() {
        ++this.contextConflicts;
    }

    public int getNumContextConflicts() {
        return this.contextConflicts++;
    }

    public List<PatternEvalRowObject> getRowObjects() {
        return this.rowObjects;
    }

    public void addRowObject(PatternEvalRowObject rowObject) {
        this.rowObjects.add(rowObject);
        switch (rowObject.getMatchType()) {
            case TRUE_POSITIVE: {
                this.incTruePositives();
                break;
            }
            case POSSIBLE_START_CODE: {
                this.incNumPossibleStartCode();
                break;
            }
            case FP_WRONG_FLOW: {
                this.incNumFPWithinBlock();
                break;
            }
            case FP_MISALIGNED: {
                this.incNumFPMisaligned();
                break;
            }
            case FP_DATA: {
                this.incNumFPData();
                break;
            }
            case POSSIBLE_START_UNDEFINED: {
                this.incNumUndefined();
                break;
            }
            case CONTEXT_CONFLICT: {
                this.incNumContextConflicts();
                break;
            }
            case PRE_PATTERN_HIT: {
                this.incNumPrePatternHit();
            }
        }
    }

    private void incNumPrePatternHit() {
        ++this.pre_pattern_hit;
    }

    public int getNumPrePatternHit() {
        return this.pre_pattern_hit;
    }
}

