/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.file;

import ghidra.features.bsim.query.BSimDBConnectTaskCoordinator;
import ghidra.features.bsim.query.BSimJDBCDataSource;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.file.BSimVectorStoreManager;
import ghidra.util.Msg;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.dbcp2.BasicDataSource;
import org.h2.tools.DeleteDbFiles;

public class BSimH2FileDBConnectionManager {
    private static final String DRIVER_CLASS_NAME = "org.h2.Driver";
    private static final int CONN_POOL_SIZE = 1;
    private static final int CONN_POOL_MAX_IDLE = 2;
    private static HashMap<BSimServerInfo, BSimH2FileDataSource> dataSourceMap = new HashMap();
    private static boolean shutdownHookInstalled = false;

    public static synchronized Collection<BSimH2FileDataSource> getAllDataSources() {
        return Collections.unmodifiableCollection(new ArrayList<BSimH2FileDataSource>(dataSourceMap.values()));
    }

    public static synchronized BSimH2FileDataSource getDataSource(BSimServerInfo fileServerInfo) {
        if (fileServerInfo.getDBType() != BSimServerInfo.DBType.file) {
            throw new IllegalArgumentException("expected file info");
        }
        BSimH2FileDBConnectionManager.enableShutdownHook();
        return dataSourceMap.computeIfAbsent(fileServerInfo, info -> new BSimH2FileDataSource((BSimServerInfo)info));
    }

    @Deprecated
    public static BSimH2FileDataSource getDataSource(URL h2FileUrl) {
        return BSimH2FileDBConnectionManager.getDataSource(new BSimServerInfo(h2FileUrl));
    }

    public static synchronized BSimH2FileDataSource getDataSourceIfExists(BSimServerInfo serverInfo) {
        return dataSourceMap.get(serverInfo);
    }

    private static synchronized boolean remove(BSimServerInfo serverInfo, boolean force) {
        BSimH2FileDataSource ds = dataSourceMap.get(serverInfo);
        if (ds == null) {
            return true;
        }
        int n = ds.bds.getNumActive();
        if (n != 0 && !force) {
            Msg.error(BSimH2FileDBConnectionManager.class, (Object)("Unable to remove data source which has " + n + " active connections"));
            return false;
        }
        ds.close();
        dataSourceMap.remove(serverInfo);
        BSimVectorStoreManager.remove(serverInfo);
        return true;
    }

    private static synchronized void enableShutdownHook() {
        if (shutdownHookInstalled) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Collection<BSimH2FileDataSource> dataSources = dataSourceMap.values();
                for (BSimH2FileDataSource ds : dataSources) {
                    int activeConnections = ds.getActiveConnections();
                    if (activeConnections != 0) {
                        Msg.error(BSimH2FileDBConnectionManager.class, (Object)(activeConnections + " BSim active H2 File connections were not properly closed: " + String.valueOf(ds.serverInfo)));
                    }
                    ds.close();
                }
                dataSourceMap.clear();
            }
        });
        shutdownHookInstalled = true;
    }

    public static class BSimH2FileDataSource
    implements BSimJDBCDataSource {
        private final BSimServerInfo serverInfo;
        private boolean successfulConnection = false;
        private BasicDataSource bds = new BasicDataSource();
        private BSimDBConnectTaskCoordinator taskCoordinator;

        private BSimH2FileDataSource(BSimServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            this.taskCoordinator = new BSimDBConnectTaskCoordinator(serverInfo);
        }

        @Override
        public BSimServerInfo getServerInfo() {
            return this.serverInfo;
        }

        @Override
        public void dispose() {
            BSimH2FileDBConnectionManager.remove(this.serverInfo, true);
        }

        public synchronized boolean delete() {
            File dbf = new File(this.serverInfo.getDBName());
            if (this.getActiveConnections() != 0) {
                Msg.error((Object)this, (Object)("Failed to delete active database: " + String.valueOf(dbf)));
                return false;
            }
            this.dispose();
            if (!dbf.isFile()) {
                return true;
            }
            String name = dbf.getName();
            int ix = name.lastIndexOf(".mv.db");
            if (ix > 0) {
                name = name.substring(0, ix);
            }
            DeleteDbFiles.execute((String)dbf.getParent(), (String)name, (boolean)true);
            if (!dbf.isFile()) {
                return true;
            }
            Msg.error((Object)this, (Object)("Failed to delete database: " + String.valueOf(dbf)));
            return false;
        }

        public boolean exists() {
            File dbf = new File(this.serverInfo.getDBName());
            return dbf.isFile();
        }

        private void close() {
            try {
                this.bds.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        @Override
        public FunctionDatabase.Status getStatus() {
            if (this.bds.isClosed()) {
                return FunctionDatabase.Status.Unconnected;
            }
            if (this.successfulConnection) {
                return FunctionDatabase.Status.Ready;
            }
            return FunctionDatabase.Status.Error;
        }

        @Override
        public int getActiveConnections() {
            return this.bds.getNumActive();
        }

        @Override
        public int getIdleConnections() {
            return this.bds.getNumIdle();
        }

        private String getH2FileUrl() {
            String dbName = this.serverInfo.getDBName();
            int ix = dbName.lastIndexOf(".mv.db");
            if (ix > 0) {
                dbName = dbName.substring(0, ix);
            }
            if (File.separatorChar == '\\' && dbName.length() > 3 && dbName.charAt(0) == '/' && Character.isLetter(dbName.charAt(1)) && dbName.charAt(2) == ':') {
                dbName = dbName.substring(1);
            }
            return "jdbc:h2:" + dbName;
        }

        private void setDefaultProperties() {
            this.bds.setDriverClassName(BSimH2FileDBConnectionManager.DRIVER_CLASS_NAME);
            this.bds.setUrl(this.getH2FileUrl() + ";MODE=PostgreSQL;DATABASE_TO_LOWER=TRUE;DEFAULT_NULL_ORDERING=HIGH;NON_KEYWORDS=key,value");
            this.bds.setInitialSize(1);
            this.bds.setMaxIdle(2);
        }

        @Override
        public synchronized Connection getConnection() throws SQLException {
            if (this.successfulConnection) {
                if (this.bds.isClosed()) {
                    this.bds.restart();
                }
                return this.bds.getConnection();
            }
            this.setDefaultProperties();
            return this.taskCoordinator.getConnection(() -> this.connect());
        }

        @Override
        public FunctionDatabase.ConnectionType getConnectionType() {
            return FunctionDatabase.ConnectionType.Unencrypted_No_Authentication;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BSimH2FileDataSource) {
                BSimH2FileDataSource ds = (BSimH2FileDataSource)obj;
                return this.bds.getUrl().equals(ds.bds.getUrl());
            }
            return false;
        }

        public int hashCode() {
            return this.bds.getUrl().hashCode();
        }

        private Connection connect() throws SQLException {
            if (this.bds.isClosed()) {
                this.bds.restart();
            }
            Connection c = this.bds.getConnection();
            this.successfulConnection = true;
            return c;
        }
    }
}

