/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import generic.theme.GIcon;
import ghidra.framework.data.LinkedGhidraSubFolder;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.FileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;

public class LinkedGhidraFolder
extends LinkedGhidraSubFolder {
    public static Icon FOLDER_LINK_CLOSED_ICON = new GIcon("icon.content.handler.linked.folder.closed");
    public static Icon FOLDER_LINK_OPEN_ICON = new GIcon("icon.content.handler.linked.folder.open");
    private final Project activeProject;
    private final DomainFolder localParent;
    private final URL folderUrl;
    private String linkedPathname;
    private URL projectUrl;

    LinkedGhidraFolder(Project activeProject, DomainFolder localParent, String linkFilename, URL folderUrl) {
        super(linkFilename);
        if (!GhidraURL.isServerRepositoryURL(folderUrl) && !GhidraURL.isLocalProjectURL(folderUrl)) {
            throw new IllegalArgumentException("Invalid Ghidra URL: " + String.valueOf(folderUrl));
        }
        this.activeProject = activeProject;
        this.localParent = localParent;
        this.folderUrl = folderUrl;
        this.linkedPathname = GhidraURL.getProjectPathname(folderUrl);
        if (this.linkedPathname.length() > 0 && this.linkedPathname.endsWith(FileSystem.SEPARATOR)) {
            this.linkedPathname = this.linkedPathname.substring(0, this.linkedPathname.length() - 1);
        }
    }

    public URL getProjectURL() {
        if (this.projectUrl == null) {
            this.projectUrl = GhidraURL.getProjectURL(this.folderUrl);
        }
        return this.projectUrl;
    }

    @Override
    LinkedGhidraFolder getLinkedRootFolder() {
        return this;
    }

    DomainFolder getLinkedFolder(String linkedPath) throws IOException {
        ProjectData projectData = this.activeProject.addProjectView(this.getProjectURL(), false);
        if (projectData == null) {
            throw new FileNotFoundException();
        }
        DomainFolder folder = projectData.getFolder(linkedPath);
        if (folder == null) {
            throw new FileNotFoundException(this.folderUrl.toExternalForm());
        }
        return folder;
    }

    @Override
    public String getLinkedPathname() {
        return this.linkedPathname;
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.localParent.getProjectLocator();
    }

    @Override
    public ProjectData getProjectData() {
        return this.localParent.getProjectData();
    }

    @Override
    public DomainFolder getParent() {
        return this.localParent;
    }

    @Override
    public String toString() {
        return "LinkedGhidraFolder: " + this.getPathname();
    }

    @Override
    public Icon getIcon(boolean isOpen) {
        return isOpen ? FOLDER_LINK_OPEN_ICON : FOLDER_LINK_CLOSED_ICON;
    }

    @Override
    public boolean isLinked() {
        return true;
    }
}

