/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.LinkedGhidraFile;
import ghidra.framework.data.LinkedGhidraFolder;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.FileSystem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;

class LinkedGhidraSubFolder
implements LinkedDomainFolder {
    private final LinkedGhidraFolder linkedRootFolder;
    private final LinkedGhidraSubFolder parent;
    private final String folderName;

    LinkedGhidraSubFolder(String folderName) {
        this.linkedRootFolder = this.getLinkedRootFolder();
        this.parent = null;
        this.folderName = folderName;
    }

    LinkedGhidraSubFolder(LinkedGhidraSubFolder parent, String folderName) {
        this.linkedRootFolder = parent.getLinkedRootFolder();
        this.parent = parent;
        this.folderName = folderName;
    }

    LinkedGhidraFolder getLinkedRootFolder() {
        return this.linkedRootFolder;
    }

    @Override
    public boolean isInWritableProject() {
        return false;
    }

    @Override
    public DomainFolder getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.folderName;
    }

    @Override
    public DomainFolder getLinkedFolder() throws IOException {
        return this.linkedRootFolder.getLinkedFolder(this.getLinkedPathname());
    }

    @Override
    public int compareTo(DomainFolder df) {
        return this.getName().compareToIgnoreCase(df.getName());
    }

    @Override
    public DomainFolder setName(String newName) throws InvalidNameException, IOException {
        throw new ReadOnlyException("linked folder is read only");
    }

    @Override
    public URL getSharedProjectURL() {
        URL projectURL = this.getLinkedRootFolder().getProjectURL();
        if (GhidraURL.isServerRepositoryURL(projectURL)) {
            Object path;
            String urlStr = projectURL.toExternalForm();
            if (urlStr.endsWith(FileSystem.SEPARATOR)) {
                urlStr = urlStr.substring(0, urlStr.length() - 1);
            }
            if (!((String)(path = this.getLinkedPathname())).endsWith(FileSystem.SEPARATOR)) {
                path = (String)path + FileSystem.SEPARATOR;
            }
            try {
                return new URL(urlStr + (String)path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL getLocalProjectURL() {
        ProjectLocator projectLocator = this.parent.getProjectLocator();
        if (!projectLocator.isTransient()) {
            return GhidraURL.makeURL(projectLocator, this.getPathname(), null);
        }
        return null;
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.parent.getProjectLocator();
    }

    @Override
    public ProjectData getProjectData() {
        return this.parent.getProjectData();
    }

    @Override
    public String getPathname() {
        Object path = this.getParent().getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + this.folderName;
        return path;
    }

    public String getLinkedPathname() {
        Object path = this.parent.getLinkedPathname();
        if (!((String)path).endsWith(FileSystem.SEPARATOR)) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + this.folderName;
        return path;
    }

    public LinkedGhidraSubFolder[] getFolders() {
        try {
            DomainFolder linkedFolder = this.getLinkedFolder();
            DomainFolder[] folders = linkedFolder.getFolders();
            LinkedGhidraSubFolder[] linkedSubFolders = new LinkedGhidraSubFolder[folders.length];
            for (int i = 0; i < folders.length; ++i) {
                linkedSubFolders[i] = new LinkedGhidraSubFolder(this, folders[i].getName());
            }
            return linkedSubFolders;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Linked folder failure: " + e.getMessage()));
            return new LinkedGhidraSubFolder[0];
        }
    }

    @Override
    public LinkedGhidraSubFolder getFolder(String name) {
        try {
            DomainFolder linkedFolder = this.getLinkedFolder();
            DomainFolder f = linkedFolder.getFolder(name);
            if (f != null) {
                return new LinkedGhidraSubFolder(this, name);
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Linked folder failure: " + e.getMessage()));
        }
        return null;
    }

    @Override
    public DomainFile[] getFiles() {
        try {
            DomainFolder linkedFolder = this.getLinkedFolder();
            DomainFile[] files = linkedFolder.getFiles();
            DomainFile[] linkedSubFolders = new LinkedGhidraFile[files.length];
            for (int i = 0; i < files.length; ++i) {
                linkedSubFolders[i] = new LinkedGhidraFile(this, files[i].getName());
            }
            return linkedSubFolders;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Linked folder failure: " + e.getMessage()));
            return new LinkedGhidraFile[0];
        }
    }

    public DomainFile getLinkedFileNoError(String name) {
        try {
            DomainFolder linkedFolder = this.getLinkedFolder();
            return linkedFolder.getFile(name);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Linked folder failure: " + e.getMessage()));
            return null;
        }
    }

    DomainFile getLinkedFile(String name) throws IOException {
        DomainFolder linkedFolder = this.getLinkedFolder();
        DomainFile df = linkedFolder.getFile(name);
        if (df == null) {
            throw new FileNotFoundException("linked-file '" + name + "' not found");
        }
        return df;
    }

    @Override
    public DomainFile getFile(String name) {
        DomainFile f = this.getLinkedFileNoError(name);
        return f != null ? new LinkedGhidraFile(this, name) : null;
    }

    @Override
    public boolean isEmpty() {
        try {
            DomainFolder linkedFolder = this.getLinkedFolder();
            return linkedFolder.isEmpty();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Linked folder failure: " + e.getMessage()));
            return true;
        }
    }

    @Override
    public DomainFile createFile(String name, DomainObject obj, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        throw new ReadOnlyException("linked folder is read only");
    }

    @Override
    public DomainFile createFile(String name, File packFile, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        throw new ReadOnlyException("linked folder is read only");
    }

    @Override
    public DomainFolder createFolder(String name) throws InvalidNameException, IOException {
        throw new ReadOnlyException("linked folder is read only");
    }

    @Override
    public void delete() throws IOException {
        throw new ReadOnlyException("linked folder is read only");
    }

    @Override
    public DomainFolder moveTo(DomainFolder newParent) throws IOException {
        throw new ReadOnlyException("linked folder is read only");
    }

    @Override
    public DomainFolder copyTo(DomainFolder newParent, TaskMonitor monitor) throws IOException, CancelledException {
        DomainFolder linkedFolder = this.getLinkedFolder();
        return linkedFolder.copyTo(newParent, monitor);
    }

    @Override
    public DomainFile copyToAsLink(DomainFolder newParent) throws IOException {
        DomainFolder linkedFolder = this.getLinkedFolder();
        return linkedFolder.copyToAsLink(newParent);
    }

    @Override
    public void setActive() {
    }

    public String toString() {
        return "LinkedGhidraSubFolder: " + this.getPathname();
    }

    @Override
    public Icon getIcon(boolean isOpen) {
        return isOpen ? OPEN_FOLDER_ICON : CLOSED_FOLDER_ICON;
    }
}

