/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class ReverseLineReader {
    private static final int BUFFER_SIZE = 8192;
    private final String encoding;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    public RandomAccessFile raf;

    public ReverseLineReader(String encoding, RandomAccessFile raf) throws IOException {
        this.raf = raf;
        this.encoding = encoding;
    }

    public void setFilePos(long position) {
        try {
            this.raf.seek(position < 0L ? 0L : position);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized String readLine() throws IOException {
        if (this.raf.getFilePointer() == 0L) {
            return null;
        }
        long end = this.raf.getFilePointer();
        long start = end - 8192L;
        if (start < 0L) {
            start = 0L;
        }
        byte[] linePlus = new byte[(int)(end - start)];
        this.raf.seek(start);
        this.raf.read(linePlus);
        for (int i = linePlus.length - 1; i >= -1; --i) {
            if (i == -1) {
                this.raf.seek(0L);
                String str = this.bufToString();
                return str;
            }
            byte c = linePlus[i];
            if (c == 13 || c == 10) {
                String str = this.bufToString();
                int newlineSubtrahend = 0;
                if (c == 10 && i > 0 && linePlus[i - 1] == 13) {
                    newlineSubtrahend = 1;
                }
                this.raf.seek(this.raf.getFilePointer() - (long)(linePlus.length - i) - (long)newlineSubtrahend);
                return str;
            }
            this.baos.write(c);
        }
        return null;
    }

    private synchronized String bufToString() throws UnsupportedEncodingException {
        if (this.baos.size() == 0) {
            return "";
        }
        byte[] bytes = this.baos.toByteArray();
        for (int i = 0; i < bytes.length / 2; ++i) {
            byte t = bytes[i];
            bytes[i] = bytes[bytes.length - i - 1];
            bytes[bytes.length - i - 1] = t;
        }
        this.baos.reset();
        return new String(bytes, this.encoding);
    }
}

