/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.theme.gui.GThemeValuesCache;
import docking.theme.gui.ProtectedIcon;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import generic.theme.IconValue;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import resources.icons.LazyImageIcon;
import resources.icons.ScaledImageIcon;
import resources.icons.UrlImageIcon;

public class ThemeIconTableModel
extends GDynamicColumnTableModel<IconValue, Object> {
    private List<IconValue> icons;
    private GThemeValueMap currentValues;
    private GThemeValueMap themeValues;
    private GThemeValueMap defaultValues;
    private GThemeValuesCache valuesProvider;
    private boolean showSystemValues;

    public ThemeIconTableModel(GThemeValuesCache valuesProvider) {
        super((ServiceProvider)new ServiceProviderStub());
        this.valuesProvider = valuesProvider;
        this.load();
    }

    public void setShowSystemValues(boolean show) {
        this.showSystemValues = show;
    }

    public boolean isShowingSystemValues() {
        return this.showSystemValues;
    }

    protected void filter() {
        ArrayList<IconValue> filtered = new ArrayList<IconValue>();
        for (IconValue iconValue : this.icons) {
            String id = iconValue.getId();
            if (this.showSystemValues) {
                filtered.add(iconValue);
                continue;
            }
            if (Gui.isSystemId((String)id)) continue;
            filtered.add(iconValue);
        }
        this.icons = filtered;
    }

    public void reloadCurrent() {
        this.currentValues = this.valuesProvider.getCurrentValues();
        this.icons = this.currentValues.getIcons();
        this.fireTableDataChanged();
    }

    public void reloadAll() {
        this.load();
        this.fireTableDataChanged();
    }

    private void load() {
        this.currentValues = this.valuesProvider.getCurrentValues();
        this.icons = this.currentValues.getIcons();
        this.themeValues = this.valuesProvider.getThemeValues();
        this.defaultValues = this.valuesProvider.getDefaultValues();
        this.filter();
    }

    @Override
    public String getName() {
        return "Fonts";
    }

    @Override
    public List<IconValue> getModelData() {
        return this.icons;
    }

    @Override
    protected TableColumnDescriptor<IconValue> createTableColumnDescriptor() {
        TableColumnDescriptor<IconValue> descriptor = new TableColumnDescriptor<IconValue>();
        descriptor.addVisibleColumn(new IdColumn(this));
        descriptor.addVisibleColumn(new IconValueColumn(this, "Current Icon", () -> this.currentValues));
        descriptor.addVisibleColumn(new IconValueColumn(this, "Theme Icon", () -> this.themeValues));
        descriptor.addVisibleColumn(new IconValueColumn(this, "Default Icon", () -> this.defaultValues));
        return descriptor;
    }

    @Override
    public Object getDataSource() {
        return null;
    }

    public IconValue getThemeValue(String id) {
        return this.themeValues.getIcon(id);
    }

    private class IdColumn
    extends AbstractDynamicTableColumn<IconValue, String, Object> {
        private IdColumn(ThemeIconTableModel themeIconTableModel) {
        }

        @Override
        public String getColumnName() {
            return "Id";
        }

        @Override
        public String getValue(IconValue iconValue, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            return iconValue.getId();
        }

        @Override
        public int getColumnPreferredWidth() {
            return 300;
        }
    }

    private class IconValueColumn
    extends AbstractDynamicTableColumn<IconValue, ResolvedIcon, Object> {
        private ThemeIconRenderer renderer;
        private String name;
        private Supplier<GThemeValueMap> valueSupplier;

        IconValueColumn(ThemeIconTableModel themeIconTableModel, String name, Supplier<GThemeValueMap> supplier) {
            this.name = name;
            this.valueSupplier = supplier;
            this.renderer = themeIconTableModel.new ThemeIconRenderer();
        }

        @Override
        public String getColumnName() {
            return this.name;
        }

        @Override
        public ResolvedIcon getValue(IconValue iconValue, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            String id;
            GThemeValueMap valueMap = this.valueSupplier.get();
            IconValue value = valueMap.getIcon(id = iconValue.getId());
            if (value == null) {
                return null;
            }
            Icon icon = value.get(valueMap);
            return new ResolvedIcon(id, value.getReferenceId(), icon);
        }

        @Override
        public GColumnRenderer<ResolvedIcon> getColumnRenderer() {
            return this.renderer;
        }

        @Override
        public Comparator<ResolvedIcon> getComparator() {
            return (v1, v2) -> {
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 == null) {
                    return 1;
                }
                if (v2 == null) {
                    return -1;
                }
                return v1.icon().toString().compareTo(v2.icon().toString());
            };
        }

        @Override
        public int getColumnPreferredWidth() {
            return 300;
        }
    }

    private record ResolvedIcon(String id, String refId, Icon icon) {
    }

    private class ThemeIconRenderer
    extends AbstractGColumnRenderer<ResolvedIcon> {
        public ThemeIconRenderer() {
            this.setFont(this.getFixedWidthFont());
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component comp = super.getTableCellRendererComponent(data);
            JLabel label = (JLabel)comp;
            ResolvedIcon resolved = (ResolvedIcon)data.getValue();
            String text = this.getValueText(resolved);
            Icon icon = this.prepareIcon(resolved.icon());
            label.setIcon(icon);
            label.setText(text);
            label.setOpaque(true);
            return label;
        }

        private Icon prepareIcon(Icon icon) {
            if (!(icon instanceof LazyImageIcon)) {
                icon = new ProtectedIcon(icon);
            }
            if (icon.getIconWidth() != 16 && icon.getIconHeight() != 16) {
                icon = new ScaledImageIcon(icon, 16, 16);
            }
            return icon;
        }

        private String getValueText(ResolvedIcon resolvedIcon) {
            ImageIcon imageIcon;
            String description;
            if (resolvedIcon == null) {
                return "<No Value>";
            }
            Icon icon = resolvedIcon.icon();
            String sizeString = "[" + icon.getIconWidth() + "x" + icon.getIconHeight() + "] ";
            Object iconString = "<JAVA ICON>";
            if (icon instanceof UrlImageIcon) {
                UrlImageIcon urlIcon = (UrlImageIcon)icon;
                iconString = urlIcon.getOriginalPath();
            } else if (icon instanceof ImageIcon && (description = (imageIcon = (ImageIcon)icon).getDescription()) != null) {
                iconString = "[" + description + "]";
            }
            if (resolvedIcon.refId() != null) {
                iconString = resolvedIcon.refId() + "  [" + (String)iconString + "]";
            }
            return String.format("%-8s%s", sizeString, iconString);
        }

        @Override
        public String getFilterString(ResolvedIcon iconValue, Settings settings) {
            return this.getValueText(iconValue);
        }
    }
}

